/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.statistics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.LocalFileCustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.execution.executable.ExecutableComposerExecution;
import com.jetbrains.php.composer.execution.phar.PharComposerExecution;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.composer.statistics.ComposerExecutorStatProvider;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.composer.statistics.ComposerPackageVersionParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ComposerConfigCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("php.composer.config", 11);
    public static final StringEventField JSON_STATE = EventFields.String((String)"state", List.of("configured", "foundInBaseDir", "foundOutOfBaseDir", "none"));
    public static final EventField<Integer> JSON_IN_SUBDIRS = EventFields.RoundedInt((String)"json_in_subdirs");
    public static final EventField<Integer> CONFIGURED_SUBPROJECTS = EventFields.RoundedInt((String)"configured_subprojects");
    public static final IntEventField MAX_DEPTH = EventFields.Int((String)"max_depth");
    public static final StringListEventField PHP_VERSIONS = EventFields.StringListValidatedByRegexp((String)"php_versions", (String)"version");
    private static final BooleanEventField CUSTOM_VENDOR_DIR = EventFields.Boolean((String)"custom_vendor_dir");
    private static final VarargEventId JSON = GROUP.registerVarargEvent("json", new EventField[]{JSON_STATE, JSON_IN_SUBDIRS, CONFIGURED_SUBPROJECTS, MAX_DEPTH, PHP_VERSIONS, CUSTOM_VENDOR_DIR});
    private static final EventId2<Boolean, ComposerDataService.SynchronizationState> SYNC = GROUP.registerEvent("sync", (EventField)EventFields.Boolean((String)"libs"), (EventField)EventFields.Enum((String)"settings", ComposerDataService.SynchronizationState.class));
    private static final StringEventField NAME = EventFields.StringValidatedByCustomRule((String)"name", ComposerPackageWhitelistRule.class);
    private static final BooleanEventField DEV = EventFields.Boolean((String)"dev");
    private static final StringEventField VERSION = new StringEventField("version"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{enum:any|master|branch|undefined}", "{regexp#version}");
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/statistics/ComposerConfigCollector$1", "getValidationRule"));
        }
    };
    private static final StringEventField CONSTRAINT = EventFields.String((String)"constraint", List.of(">", ">=", "-", "~", "^", "="));
    private static final VarargEventId PACKAGE = GROUP.registerVarargEvent("package", new EventField[]{NAME, DEV, VERSION, CONSTRAINT});
    private static final EventId2<String, String> INSTALLED_PACKAGE = GROUP.registerEvent("installed_package", (EventField)NAME, (EventField)VERSION);
    private static final StringEventField REPOSITORY_TYPE = EventFields.String((String)"repository_type", List.of("composer", "vcs", "git", "svn", "fossil", "hg", "pear", "package", "artifact", "path"));
    private static final VarargEventId REPOSITORY = GROUP.registerVarargEvent("repository", new EventField[]{REPOSITORY_TYPE});
    private static final StringEventField TYPE = EventFields.String((String)"type", List.of("unknown", "ExecutableComposerExecution", "PharComposerExecution", "ComposerRemoteInterpreterExecution"));
    private static final BooleanEventField CONFIGURED = EventFields.Boolean((String)"configured");
    private static final BooleanEventField DEFAULT_FIELD = EventFields.Boolean((String)"default");
    private static final StringEventField INTERPRETER_TYPE = EventFields.String((String)"interpreterType", List.of("third.party", "unconfigured", "lost", "corrupted", "local", "vagrant", "docker", "docker-compose", "ssh-credentials", "web-deployment"));
    private static final VarargEventId EXECUTOR = GROUP.registerVarargEvent("executor", new EventField[]{TYPE, CONFIGURED, DEFAULT_FIELD, INTERPRETER_TYPE});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        result.add(this.getJsonMetric(project));
        if (!StringUtil.isEmptyOrSpaces((String)ComposerConfigManager.getInstance(project).getMainConfigPath())) {
            result.add(ComposerConfigCollector.getSyncMetrics(project));
            result.addAll(this.getConfigsMetrics(project));
            result.addAll(ComposerConfigCollector.getInstalledPackagesMetric(project));
        }
        result.add(ComposerConfigCollector.getExecutorMetric(project));
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            ComposerConfigCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public MetricEvent getJsonMetric(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(2);
        }
        Collection composerJsonFiles = (Collection)ReadAction.nonBlocking(() -> FilenameIndex.getVirtualFilesByName((String)"composer.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))).executeSynchronously();
        List outsideVendor = ContainerUtil.filter((Collection)composerJsonFiles, c -> !c.getPath().contains("/vendor/"));
        ComposerConfigManager configManager = ComposerConfigManager.getInstance(project);
        VirtualFile mainConfig = configManager.getMainConfig() != null ? configManager.getMainConfig() : ComposerConfigCollector.findMainConfig(project);
        List subProjects = ContainerUtil.filter((Collection)outsideVendor, virtualFile -> !virtualFile.equals(mainConfig));
        return JSON.metric(new EventPair[]{JSON_STATE.with((Object)this.getComposerJsonStatus(project, composerJsonFiles)), PHP_VERSIONS.with(ComposerConfigCollector.getPhpVersions(outsideVendor)), CONFIGURED_SUBPROJECTS.with((Object)configManager.getSubProjectConfigs().size()), JSON_IN_SUBDIRS.with((Object)subProjects.size()), MAX_DEPTH.with((Object)ComposerConfigCollector.countMaxDepth(project, subProjects)), CUSTOM_VENDOR_DIR.with((Object)ComposerConfigCollector.hasCustomVendorDir(project, configManager))});
    }

    private static boolean hasCustomVendorDir(@NotNull Project project, ComposerConfigManager configManager) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(3);
        }
        for (VirtualFile config : configManager.getAllConfigs()) {
            ComposerLibraryService libraryService = ComposerLibraryServiceFactory.getInstance(project, config);
            VirtualFile vendorDir = libraryService.getVendorDir();
            if (vendorDir == null || vendorDir.getName().equalsIgnoreCase("vendor")) continue;
            return true;
        }
        return false;
    }

    private static int countMaxDepth(@NotNull Project project, List<VirtualFile> subProjects) {
        VirtualFile projectDir;
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(4);
        }
        if ((projectDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return 0;
        }
        return subProjects.stream().map(v -> VfsUtilCore.getRelativePath((VirtualFile)v, (VirtualFile)projectDir)).filter(Objects::nonNull).map(p -> StringUtil.countChars((CharSequence)p, (char)'/')).max(Integer::compare).orElse(0);
    }

    private static List<String> getPhpVersions(@NotNull List<VirtualFile> composerConfigs) {
        if (composerConfigs == null) {
            ComposerConfigCollector.$$$reportNull$$$0(5);
        }
        return ((StreamEx)((StreamEx)StreamEx.of(composerConfigs).map(f -> ComposerConfigCollector.parseJson(f)).nonNull().map(json -> (JsonObject)ObjectUtils.tryCast((Object)json, JsonObject.class)).nonNull().map(json -> (JsonObject)ObjectUtils.tryCast((Object)json.get("require"), JsonObject.class)).nonNull().map(require -> require.get("php")).nonNull().flatMap(php -> ComposerConfigCollector.parseVersions(php).stream()).sorted((a, b) -> a.getVersion().equals(b.getVersion()) && a.getConstraint() == b.getConstraint() ? 0 : (a.isGreaterThan((ComposerPackageVersion)b) ? -1 : 1))).map(version -> version.getVersion()).distinct()).toList();
    }

    @NotNull
    public Set<MetricEvent> getConfigsMetrics(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(6);
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        for (VirtualFile configFile : ComposerConfigManager.getInstance(project).getAllConfigs()) {
            JsonElement config = ComposerConfigCollector.parseJson(configFile);
            if (!(config instanceof JsonObject)) continue;
            JsonObject obj = config.getAsJsonObject();
            ComposerConfigCollector.addPackages(result, obj.get("require"), false);
            ComposerConfigCollector.addPackages(result, obj.get("require-dev"), true);
            ComposerConfigCollector.addRepositories(result, obj.get("repositories"));
        }
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            ComposerConfigCollector.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static void addRepositories(@NotNull Set<MetricEvent> result, @Nullable JsonElement repositories) {
        if (result == null) {
            ComposerConfigCollector.$$$reportNull$$$0(8);
        }
        if (!(repositories instanceof JsonArray)) {
            return;
        }
        for (JsonElement repository : (JsonArray)repositories) {
            JsonObject repositoryObject;
            JsonElement type;
            if (!(repository instanceof JsonObject) || (type = (repositoryObject = (JsonObject)repository).get("type")) == null) continue;
            result.add(REPOSITORY.metric(new EventPair[]{REPOSITORY_TYPE.with((Object)type.getAsString())}));
        }
    }

    private static void addPackages(@NotNull Set<MetricEvent> result, @Nullable JsonElement require, boolean isDev) {
        if (result == null) {
            ComposerConfigCollector.$$$reportNull$$$0(9);
        }
        if (require instanceof JsonObject) {
            Set entries = ((JsonObject)require).entrySet();
            for (Map.Entry entry : entries) {
                ArrayList<EventPair> data = new ArrayList<EventPair>();
                data.add(NAME.with((Object)((String)entry.getKey())));
                data.add(DEV.with((Object)isDev));
                List<ComposerPackageVersion> versions = ComposerConfigCollector.parseVersions((JsonElement)entry.getValue());
                for (ComposerPackageVersion version : versions) {
                    ArrayList<EventPair> newData = new ArrayList<EventPair>(data);
                    newData.add(VERSION.with((Object)version.getVersion()));
                    newData.add(CONSTRAINT.with((Object)version.getConstraint().toString()));
                    result.add(PACKAGE.metric(newData));
                }
            }
        }
    }

    @VisibleForTesting
    public static Collection<MetricEvent> getInstalledPackagesMetric(Project project) {
        return ComposerInstalledPackagesService.getAllInstalledPackages(project).stream().map(e -> INSTALLED_PACKAGE.metric((Object)e.name(), (Object)ComposerConfigCollector.trimMinorVersion(e.version()))).collect(Collectors.toSet());
    }

    @NotNull
    private static List<ComposerPackageVersion> parseVersions(@NotNull JsonElement value) {
        List<ComposerPackageVersion> versions;
        if (value == null) {
            ComposerConfigCollector.$$$reportNull$$$0(10);
        }
        List<ComposerPackageVersion> list = versions = value instanceof JsonPrimitive ? ComposerPackageVersionParser.parseAllVersions(value.getAsString()) : ContainerUtil.emptyList();
        if (versions.isEmpty()) {
            return new SmartList((Object)new ComposerPackageVersion("undefined", ComposerPackageVersion.PackageVersionConstraint.EQUAL));
        }
        List list2 = ContainerUtil.map(versions, ComposerConfigCollector::trimMinorVersion);
        if (list2 == null) {
            ComposerConfigCollector.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static ComposerPackageVersion trimMinorVersion(ComposerPackageVersion source) {
        String version = source.getVersion();
        String trimmedVersion = ComposerConfigCollector.trimMinorVersion(version);
        return trimmedVersion.equals(version) ? source : new ComposerPackageVersion(trimmedVersion, source.getConstraint());
    }

    @NotNull
    private static String trimMinorVersion(@NotNull String version) {
        Version parsedVersion;
        if (version == null) {
            ComposerConfigCollector.$$$reportNull$$$0(12);
        }
        if ((parsedVersion = Version.parseVersion((String)(version = StringUtil.trimStart((String)version, (String)"v")))) != null && parsedVersion.bugfix >= 0) {
            String string = parsedVersion.major + "." + parsedVersion.minor;
            if (string == null) {
                ComposerConfigCollector.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = version;
        if (string == null) {
            ComposerConfigCollector.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static JsonElement parseJson(@NotNull VirtualFile config) {
        if (config == null) {
            ComposerConfigCollector.$$$reportNull$$$0(15);
        }
        try {
            return ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException throwable) {
            return null;
        }
    }

    @Nullable
    private String getPathToConfig(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(16);
        }
        return ComposerConfigManager.getInstance(project).getMainConfigPath();
    }

    @NotNull
    private String getComposerJsonStatus(@NotNull Project project, @NotNull Collection<VirtualFile> composerJsonFiles) {
        String path;
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(17);
        }
        if (composerJsonFiles == null) {
            ComposerConfigCollector.$$$reportNull$$$0(18);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(path = this.getPathToConfig(project)))) {
            return "configured";
        }
        if (ComposerConfigCollector.findMainConfig(project) != null) {
            return "foundInBaseDir";
        }
        return composerJsonFiles.isEmpty() ? "none" : "foundOutOfBaseDir";
    }

    @Nullable
    private static VirtualFile findMainConfig(@NotNull Project project) {
        VirtualFile projectDir;
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(19);
        }
        if ((projectDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return null;
        }
        return projectDir.findChild("composer.json");
    }

    @NotNull
    private static MetricEvent getSyncMetrics(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(20);
        }
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        MetricEvent metricEvent = SYNC.metric((Object)dataService.isUpdateLibrary(), (Object)dataService.getSynchronizationState());
        if (metricEvent == null) {
            ComposerConfigCollector.$$$reportNull$$$0(21);
        }
        return metricEvent;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private static MetricEvent getExecutorMetric(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(22);
        }
        data = new ArrayList<EventPair>();
        dataService = ComposerDataService.getInstance(project);
        execution = dataService.getComposerExecution();
        name = execution.getClass().getName();
        if (!(execution instanceof ComposerExecutorStatProvider)) ** GOTO lbl-1000
        provider = (ComposerExecutorStatProvider)execution;
        if (ExecutableComposerExecution.class.getName().equals(name) || PharComposerExecution.class.getName().equals(name) || "com.jetbrains.php.remote.composer.ComposerRemoteInterpreterExecution".equals(name)) {
            data.add(ComposerConfigCollector.TYPE.with((Object)provider.getClass().getSimpleName()));
            data.add(ComposerConfigCollector.CONFIGURED.with((Object)provider.isConfigured()));
            data.add(ComposerConfigCollector.DEFAULT_FIELD.with((Object)provider.isDefault()));
            remoteInterpreterType = provider.getRemoteInterpreterType(project);
            if (remoteInterpreterType != null) {
                data.add(ComposerConfigCollector.INTERPRETER_TYPE.with((Object)remoteInterpreterType));
            }
        } else lbl-1000:
        // 2 sources

        {
            data.add(ComposerConfigCollector.TYPE.with((Object)"unknown"));
        }
        v0 = ComposerConfigCollector.EXECUTOR.metric(data);
        if (v0 == null) {
            ComposerConfigCollector.$$$reportNull$$$0(23);
        }
        return v0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 11, 13, 14, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/statistics/ComposerConfigCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerConfigs";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJsonFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/statistics/ComposerConfigCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigsMetrics";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMinorVersion";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncMetrics";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorMetric";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJsonMetric";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomVendorDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "countMaxDepth";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPhpVersions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigsMetrics";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseVersions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trimMinorVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseJson";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPathToConfig";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getComposerJsonStatus";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findMainConfig";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSyncMetrics";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorMetric";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 11, 13, 14, 21, 23 -> new IllegalStateException(string);
        };
    }

    public static final class ComposerPackageWhitelistRule
    extends LocalFileCustomValidationRule {
        private ComposerPackageWhitelistRule() {
            super("composer_package", ComposerConfigCollector.class, "composer_packages.txt");
        }
    }
}

