/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.lib.ComposerLibraryNotificationService;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExcludedDirectoriesApplier
implements Runnable {
    private final Module myModule;
    private final Collection<VirtualFile> myExclude;
    private final Collection<VirtualFile> myBackToProject;
    private final Collection<VirtualFile> myDeletedFiles;
    private final String myNotificationMessage;

    ExcludedDirectoriesApplier(@NotNull Module module, @NotNull Collection<VirtualFile> exclude, @NotNull Collection<VirtualFile> project, @Nullable Collection<VirtualFile> deletedFiles, @Nullable String message) {
        if (module == null) {
            ExcludedDirectoriesApplier.$$$reportNull$$$0(0);
        }
        if (exclude == null) {
            ExcludedDirectoriesApplier.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ExcludedDirectoriesApplier.$$$reportNull$$$0(2);
        }
        this.myModule = module;
        this.myExclude = exclude;
        this.myBackToProject = project;
        this.myDeletedFiles = deletedFiles;
        this.myNotificationMessage = message;
    }

    @Override
    public void run() {
        ModifiableRootModel model = (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel());
        try {
            if (this.applyChanges(model)) {
                WriteAction.runAndWait(() -> model.commit());
                if (this.myNotificationMessage != null) {
                    ComposerLibraryNotificationService notificationService = ComposerLibraryNotificationService.getInstance(this.myModule.getProject());
                    notificationService.notifyWithPopupAndLinks(this.myNotificationMessage, ComposerLogMessageBuilder.Settings.DIRECTORIES);
                }
            }
        }
        finally {
            if (!model.isDisposed()) {
                model.dispose();
            }
        }
    }

    private boolean isInModule(@NotNull VirtualFile file) {
        if (file == null) {
            ExcludedDirectoriesApplier.$$$reportNull$$$0(3);
        }
        return (Boolean)DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(() -> {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myModule.getProject()).getFileIndex();
            return this.myModule.equals(index.getModuleForFile(file));
        });
    }

    private boolean applyChanges(ModifiableRootModel model) {
        ContentEntry[] contentEntries = model.getContentEntries();
        if (contentEntries.length == 0) {
            return false;
        }
        boolean changed = false;
        block0: for (VirtualFile file : this.myExclude) {
            if (!this.isInModule(file)) continue;
            String string = file.getUrl();
            String filePath = VfsUtilCore.urlToPath((String)string);
            for (ContentEntry entry : contentEntries) {
                String rootPath = VfsUtilCore.urlToPath((String)entry.getUrl());
                if (!FileUtil.isAncestor((String)rootPath, (String)filePath, (boolean)false)) continue;
                VirtualFile[] excluded = entry.getExcludeFolderFiles();
                boolean found = false;
                for (VirtualFile excludedFile : excluded) {
                    if (!excludedFile.equals(file)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                entry.addExcludeFolder(string, true);
                changed = true;
                continue block0;
            }
        }
        for (VirtualFile file : this.myBackToProject) {
            for (ContentEntry entry : contentEntries) {
                if (!entry.removeExcludeFolder(file.getUrl())) continue;
                changed = true;
            }
        }
        if (this.myDeletedFiles != null && !this.myDeletedFiles.isEmpty()) {
            for (VirtualFile file : this.myDeletedFiles) {
                String string = file.getUrl();
                for (ContentEntry entry : contentEntries) {
                    List excludeFolderUrls = entry.getExcludeFolderUrls();
                    for (String excludeFolderUrl : excludeFolderUrls) {
                        if (!VfsUtilCore.isEqualOrAncestor((String)string, (String)excludeFolderUrl) || !entry.removeExcludeFolder(excludeFolderUrl)) continue;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclude";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/lib/ExcludedDirectoriesApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

