/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json.cache;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import com.jetbrains.php.composer.json.cache.ComposerRepositoriesChangedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class RepositoriesComposerConfig
implements ComposerConfigClient<List<String>> {
    @NotNull
    public static final Topic<ComposerRepositoriesChangedListener> TOPIC = Topic.create((String)"composerRepositoriesChanged", ComposerRepositoriesChangedListener.class);

    @Override
    public List<String> parse(@NotNull Project project, @NotNull Map<String, JsonElement> elements, @NotNull VirtualFile config) {
        if (project == null) {
            RepositoriesComposerConfig.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            RepositoriesComposerConfig.$$$reportNull$$$0(1);
        }
        if (config == null) {
            RepositoriesComposerConfig.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList<String> repos = new ArrayList<String>();
        for (Map.Entry<String, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (element instanceof JsonArray) {
                for (int i = 0; i < ((JsonArray)element).size(); ++i) {
                    repos.add(((JsonArray)element).get(i).toString());
                }
                continue;
            }
            if (!(element instanceof JsonObject)) continue;
            for (String key : ((JsonObject)element).keySet()) {
                repos.add(RepositoriesComposerConfig.createObjectWithName(key, ((JsonObject)element).get(key)).toString());
            }
        }
        return repos;
    }

    @NotNull
    private static JsonObject createObjectWithName(String name, JsonElement element) {
        JsonObject object = element instanceof JsonObject ? ((JsonObject)element).deepCopy() : new JsonObject();
        object.addProperty("name", name);
        JsonObject jsonObject = object;
        if (jsonObject == null) {
            RepositoriesComposerConfig.$$$reportNull$$$0(3);
        }
        return jsonObject;
    }

    @Override
    public void consume(List<String> repositories, @NotNull Project project) {
        if (project == null) {
            RepositoriesComposerConfig.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        ((ComposerRepositoriesChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).repositoriesChanged(repositories);
        ComposerPackagesCache.reload(project);
    }

    @Override
    @NotNull
    public List<String> getPath() {
        return new SmartList((Object)"repositories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/cache/RepositoriesComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/cache/RepositoriesComposerConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectWithName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

