/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.actions.ComposerUpdateAction;
import com.jetbrains.php.composer.actions.ComposerUpdatePackageAction;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpNotInstalledPackagesInspection
extends PhpInspection {
    private static final List<String> REQUIRED_SECTIONS = List.of("require", "require-dev");
    @NonNls
    private static final String PHP = "php";
    private static final LocalQuickFix[] ALL_QUICK_FIXES = new LocalQuickFix[]{UpdatePackagesFix.INSTANCE, UpdatePackageFix.INSTANCE};
    private static final LocalQuickFix[] INSTALL_FIXES = new LocalQuickFix[]{InstallPackagesFix.INSTANCE};
    @NonNls
    public static final String EXT_PREFIX = "ext-";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PhpNotInstalledPackagesInspection.$$$reportNull$$$0(0);
        }
        if (!JsonDialectUtil.isStandardJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpNotInstalledPackagesInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(file.getProject());
        String path = composerConfigManager.getConfigPath((PsiElement)file);
        if (path == null || !FileUtil.pathsEqual((String)path, (String)file.getVirtualFile().getPath())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpNotInstalledPackagesInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final List<InstalledPackageData> installedPackagesFromConfig = ComposerConfigUtils.getInstalledPackagesFromConfig(file.getVirtualFile());
        return new JsonElementVisitor(){

            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (REQUIRED_SECTIONS.contains(o.getName())) {
                    JsonObject requires = (JsonObject)ObjectUtils.tryCast((Object)o.getValue(), JsonObject.class);
                    if (requires == null) {
                        return;
                    }
                    List packages = requires.getPropertyList();
                    if (packages.isEmpty()) {
                        return;
                    }
                    if (!ComposerLibraryServiceFactory.getInstance(o.getProject(), (PsiElement)o).vendorDirExists() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        holder.registerProblem((PsiElement)o.getNameElement(), PhpBundle.message("inspection.json.all.not.installed.packages", PhpNotInstalledPackagesInspection.this.getDisplayName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly ? INSTALL_FIXES : LocalQuickFix.EMPTY_ARRAY);
                        return;
                    }
                    List<String> packageNames = ComposerPackagesCache.getPackageNames();
                    for (JsonProperty composerPackage : packages) {
                        if (composerPackage.getName().equalsIgnoreCase(PhpNotInstalledPackagesInspection.PHP) || composerPackage.getName().startsWith(PhpNotInstalledPackagesInspection.EXT_PREFIX)) continue;
                        if (!ApplicationManager.getApplication().isUnitTestMode() && !packageNames.contains(composerPackage.getName())) {
                            return;
                        }
                        if (ContainerUtil.exists((Iterable)installedPackagesFromConfig, i -> StringUtil.equalsIgnoreCase((CharSequence)i.getName(), (CharSequence)composerPackage.getName()))) continue;
                        holder.registerProblem((PsiElement)composerPackage.getNameElement(), PhpBundle.message("inspection.json.not.installed.packages", PhpNotInstalledPackagesInspection.this.getDisplayName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly ? ALL_QUICK_FIXES : LocalQuickFix.EMPTY_ARRAY);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$1", "visitProperty"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class UpdatePackagesFix
    extends BasePackagesFix {
        static UpdatePackagesFix INSTANCE = new UpdatePackagesFix();

        private UpdatePackagesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.packages.update.fix", new Object[0]);
            if (string == null) {
                UpdatePackagesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                UpdatePackagesFix.$$$reportNull$$$0(1);
            }
            return new ComposerUpdateAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackagesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackagesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UpdatePackageFix
    extends BasePackagesFix {
        static UpdatePackageFix INSTANCE = new UpdatePackageFix();

        private UpdatePackageFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.package.update.fix", new Object[0]);
            if (string == null) {
                UpdatePackageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                UpdatePackageFix.$$$reportNull$$$0(1);
            }
            return new ComposerUpdatePackageAction(descriptor.getPsiElement().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackageFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class InstallPackagesFix
    extends BasePackagesFix {
        static InstallPackagesFix INSTANCE = new InstallPackagesFix();

        private InstallPackagesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.packages.install.fix", new Object[0]);
            if (string == null) {
                InstallPackagesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                InstallPackagesFix.$$$reportNull$$$0(1);
            }
            return new ComposerInstallAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$InstallPackagesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$InstallPackagesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static abstract class BasePackagesFix
    extends PhpQuickFixBase {
        private BasePackagesFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                BasePackagesFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                BasePackagesFix.$$$reportNull$$$0(1);
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> this.getComposerAction(descriptor).actionPerformed(AnActionEvent.createEvent((DataContext)context, null, (String)"composer.json", (ActionUiKind)ActionUiKind.NONE, null)));
        }

        @NotNull
        abstract ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor var1);

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$BasePackagesFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

