/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.lang.inspections.PhpInspection;
import org.jetbrains.annotations.NotNull;

public final class ComposerJsonFileReferencesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            ComposerJsonFileReferencesInspection.$$$reportNull$$$0(0);
        }
        if (!PhpComposerJsonUtils.insideComposerJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ComposerJsonFileReferencesInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitProperty(@NotNull JsonProperty o) {
                JsonValue value;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((value = o.getValue()) instanceof JsonArray) {
                    ((JsonArray)value).getValueList().forEach(jsonValue -> ComposerJsonFileReferencesInspection.checkValue(jsonValue, holder));
                } else {
                    ComposerJsonFileReferencesInspection.checkValue(value, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/composer/json/ComposerJsonFileReferencesInspection$1", "visitProperty"));
            }
        };
    }

    private static void checkValue(JsonValue value, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            ComposerJsonFileReferencesInspection.$$$reportNull$$$0(2);
        }
        if (PhpComposerJsonUtils.insideFilesSupportedSections((PsiElement)value) && !PhpComposerJsonUtils.insideScriptsSection((PsiElement)value) && !PhpComposerJsonUtils.insideSectionWithSuffix((PsiElement)value, "-dir")) {
            boolean resolved = false;
            for (PsiReference reference : value.getReferences()) {
                if (reference instanceof FileReference || reference.resolve() == null) continue;
                resolved = true;
            }
            if (!resolved) {
                for (PsiReference reference : value.getReferences()) {
                    String text;
                    if (!(reference instanceof FileReference) || reference.resolve() != null || StringUtil.isEmpty((String)(text = ((FileReference)reference).getText())) || text.contains("::") || text.contains("\\\\") || StringUtil.containsAnyChar((String)((FileReference)reference).getFileReferenceSet().getPathString(), (String)"*!")) continue;
                    holder.registerProblem(reference, PhpBundle.message("inspection.composer.file.reference.problem", reference.getCanonicalText()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonFileReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonFileReferencesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

