/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.settings.InlaySettingsPanel;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerPackageVersionInlayCollector
extends FactoryInlayHintsCollector
implements DumbAware {
    public ComposerPackageVersionInlayCollector(@NotNull Editor editor) {
        if (editor == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(0);
        }
        super(editor);
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        if (!(element instanceof JsonProperty)) {
            return true;
        }
        if (InlaySettingsPanel.PREVIEW_KEY.get((UserDataHolder)editor) != null) {
            if (ContainerUtil.all(Arrays.asList(element.getChildren()), e -> e instanceof JsonStringLiteral)) {
                this.addInlay(element, sink, "9.5.*", "9.6.4");
            }
            return true;
        }
        String packageName = ComposerPackageVersionInlayCollector.getPackageNameByElement(element);
        if (packageName == null) {
            return true;
        }
        ComposerInstalledPackagesService installedPackagesService = ComposerInstalledPackagesService.getInstance(project, element);
        if (installedPackagesService == null) {
            return true;
        }
        String currentVersion = installedPackagesService.getCurrentPackageVersion(packageName);
        if (currentVersion == null) {
            return true;
        }
        ComposerAvailablePackageVersionsService availablePackageVersionsService = ComposerAvailablePackageVersionsService.getInstance(project, element);
        if (availablePackageVersionsService == null) {
            return true;
        }
        String availableVersion = availablePackageVersionsService.getUpdateAvailableVersion(packageName);
        this.addInlay(element, sink, currentVersion, availableVersion);
        return true;
    }

    private void addInlay(@NotNull PsiElement element, @NotNull InlayHintsSink sink, String currentVersion, String availableVersion) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(5);
        }
        int offset = ComposerPackageVersionInlayCollector.getOffset(element);
        sink.addInlineElement(offset, true, this.formatHintPresentation(ComposerPackageVersionInlayCollector.buildInlayText(currentVersion, availableVersion)), false);
    }

    @NotNull
    private static String buildInlayText(@NotNull String currentVersion, @Nullable String availableVersion) {
        if (currentVersion == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(6);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(currentVersion);
        if (availableVersion != null) {
            stringBuilder.append(", ");
            stringBuilder.append(PhpBundle.message("framework.composer.package.version.available.0", availableVersion));
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static int getOffset(@NotNull PsiElement element) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(8);
        }
        int offset = element.getTextRange().getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == JsonElementTypes.COMMA) {
            offset = nextSibling.getTextRange().getEndOffset();
        }
        return offset;
    }

    @NotNull
    private InlayPresentation formatHintPresentation(@NotNull String message) {
        if (message == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(9);
        }
        PresentationFactory factory = this.getFactory();
        InlayPresentation inlayPresentation = factory.withTooltip(PhpBundle.message("hint.text.installed.version", new Object[0]), factory.roundWithBackground(factory.smallText(message)));
        if (inlayPresentation == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(10);
        }
        return inlayPresentation;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getPackageNameByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        JsonProperty property = PhpPsiUtil.getParentOfClass(element, false, JsonProperty.class);
        if (property == null) {
            return null;
        }
        String packageName = ComposerConfigUtils.getPackageName(property);
        if (packageName == null) {
            return null;
        }
        return packageName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVersion";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/update/ComposerPackageVersionInlayCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerPackageVersionInlayCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInlayText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHintPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInlay";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildInlayText";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatHintPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }
}

