/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerDumpAutoloadDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JBCheckBox myScriptCheckBox;
    private JBCheckBox myOptimizeCheckBox;
    private JBCheckBox myClassMapCheckBox;
    private JBCheckBox myAPCuCheckBox;
    private JBCheckBox myDevCheckBox;

    protected ComposerDumpAutoloadDialog(@Nullable Project project) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PhpBundle.message("composer.autoloader.generation.settings.name", objectArray));
        this.setOKButtonText(PhpBundle.message("composer.generate.list.popup.title", new Object[0]));
        this.myOptimizeCheckBox.addActionListener(e -> {
            if (!this.myOptimizeCheckBox.isSelected()) {
                this.myClassMapCheckBox.setSelected(false);
            }
        });
        this.myClassMapCheckBox.addActionListener(e -> {
            if (this.myClassMapCheckBox.isSelected()) {
                this.myOptimizeCheckBox.setSelected(true);
            }
        });
        this.init();
        this.pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void setCommandLineOptions(@NlsSafe String options) {
        options = StringUtil.notNullize((String)options);
        this.myScriptCheckBox.setSelected(options.contains("--no-scripts"));
        this.myOptimizeCheckBox.setSelected(options.contains("--optimize") || options.contains("--classmap-authoritative"));
        this.myClassMapCheckBox.setSelected(options.contains("--classmap-authoritative"));
        this.myAPCuCheckBox.setSelected(options.contains("--apcu"));
        this.myDevCheckBox.setSelected(options.contains("--no-dev"));
    }

    @NotNull
    public String getCommandLineOptions() {
        StringBuilder sb = new StringBuilder("--no-interaction --ansi --verbose");
        if (this.myScriptCheckBox.isSelected()) {
            sb.append(" --no-scripts");
        }
        if (this.myOptimizeCheckBox.isSelected() && !this.myClassMapCheckBox.isSelected()) {
            sb.append(" --optimize");
        }
        if (this.myClassMapCheckBox.isSelected()) {
            sb.append(" --classmap-authoritative");
        }
        if (this.myAPCuCheckBox.isSelected()) {
            sb.append(" --apcu");
        }
        if (this.myDevCheckBox.isSelected()) {
            sb.append(" --no-dev");
        }
        String string = sb.toString();
        if (string == null) {
            ComposerDumpAutoloadDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ComposerDumpAutoloadDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptCheckBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.checkbox.skip.scripts.execution"));
        jPanel.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOptimizeCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.checkbox.optimize.autoloader.convert.psr.0.4.rules.to.a.classmap"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDevCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.checkbox.disable.autoload.dev.dependencies"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAPCuCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.checkbox.use.apcu.to.cache.found.not.found.classes"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassMapCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.checkbox.autoload.classes.from.the.classmap.only"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerDumpAutoloadDialog.class).getString("composer.label.can.be.time.consuming"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 3));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/actions/ComposerDumpAutoloadDialog", "getCommandLineOptions"));
    }
}

