/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.composer.execution.ComposerExecution;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerCommandRunner {
    private static final long CHECKING_TIMEOUT_IN_MILLISECONDS = 1000L;
    @NotNull
    private final ComposerExecution myExecution;
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myWorkingDir;
    @NotNull
    private final ProgressIndicator myIndicator;

    public ComposerCommandRunner(@NotNull ComposerExecution execution, @NotNull Project project, @Nullable String dir, @NotNull ProgressIndicator indicator) {
        if (execution == null) {
            ComposerCommandRunner.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ComposerCommandRunner.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ComposerCommandRunner.$$$reportNull$$$0(2);
        }
        this.myExecution = execution;
        this.myProject = project;
        this.myWorkingDir = dir;
        this.myIndicator = indicator;
    }

    @NotNull
    public ExecutionResult runCommand(@NotNull List<String> command, @NotNull ProcessListener listener) {
        if (command == null) {
            ComposerCommandRunner.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            ComposerCommandRunner.$$$reportNull$$$0(4);
        }
        boolean cancelledByUser = false;
        ExecutionException exception = null;
        Integer exitCode = null;
        if (!this.myProject.isDisposed()) {
            try {
                boolean finished;
                ProcessHandler processHandler = this.myExecution.createProcessHandler(this.myProject, this.myWorkingDir, command, StringUtil.join(command, (String)" "));
                processHandler.addProcessListener(listener);
                processHandler.startNotify();
                while (!(finished = processHandler.waitFor(1000L))) {
                    if (!this.myIndicator.isCanceled()) continue;
                    cancelledByUser = true;
                    this.myExecution.cancelProcess(processHandler);
                    break;
                }
                exitCode = processHandler.getExitCode();
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (this.myIndicator.isCanceled()) {
                cancelledByUser = true;
            }
        }
        return new ExecutionResult(cancelledByUser, exception, exitCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ExecutionResult {
        public final boolean myProgressIndicatorCancelled;
        @Nullable
        public final ExecutionException myException;
        @Nullable
        public final Integer exitCode;

        ExecutionResult(boolean myProgressIndicatorCancelled, @Nullable ExecutionException exception, @Nullable Integer exitCode) {
            this.myProgressIndicatorCancelled = myProgressIndicatorCancelled;
            this.myException = exception;
            this.exitCode = exitCode;
        }

        public boolean isSuccess() {
            return this.myException == null && !this.myProgressIndicatorCancelled && this.exitCode != null && this.exitCode == 0;
        }
    }
}

