/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInitSupportAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        boolean enabled;
        if (e == null) {
            ComposerInitSupportAction.$$$reportNull$$$0(0);
        }
        boolean bl = enabled = (project = e.getProject()) != null;
        if (enabled) {
            ComposerDataService service = ComposerDataService.getInstance(project);
            enabled = !service.isExecutionWellConfigured(true) || !service.isConfigWellConfigured();
        }
        boolean isInPopup = e.isFromContextMenu();
        if (enabled && isInPopup && "EditorPopup".equals(e.getPlace())) {
            enabled = false;
        }
        e.getPresentation().setEnabled(enabled);
        if (isInPopup) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComposerInitSupportAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile parentFolder = ComposerInitSupportAction.getParentFolder(project);
        if (parentFolder == null) {
            return;
        }
        ComposerActionStatistics.reportAction(ComposerActionStatistics.Action.INIT, e.getPlace(), e.getProject());
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        if (!dataService.askForValidConfigurationIfNeeded()) {
            return;
        }
        if (dataService.isConfigWellConfigured()) {
            return;
        }
        VirtualFile config = parentFolder.findChild("composer.json");
        if (config == null || !config.exists()) {
            config = ComposerInitSupportAction.findSuitableConfig(project);
        }
        if (config != null && config.exists()) {
            DumbAwareAction changeSettingAction = new DumbAwareAction(PhpBundle.message("composer.change.setting.action.name", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new ComposerConfigurable(project));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerInitSupportAction$1", "actionPerformed"));
                }
            };
            dataService.setConfigPathAndLibraryUpdateStatus(config.getPath(), true);
            Notification errorNotification = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer.notification.title.init.composer", new Object[0]), PhpBundle.message("framework.composer.file.0.set.as.composer.config.change.setting.a.href.here.a", FileUtil.toSystemIndependentName((String)config.getPath())), NotificationType.INFORMATION);
            errorNotification.addAction((AnAction)changeSettingAction);
            Notifications.Bus.notify((Notification)errorNotification, (Project)project);
            return;
        }
        VirtualFile finalParentFolder = parentFolder;
        Runnable initializer = () -> ComposerUtils.initConfig(finalParentFolder, project, (Object)this);
        ApplicationManager.getApplication().runWriteAction(initializer);
    }

    private static VirtualFile findSuitableConfig(Project project) {
        if (project == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        Collection files = FilenameIndex.getVirtualFilesByName((String)"composer.json", (GlobalSearchScope)scope);
        if (files.isEmpty()) {
            return null;
        }
        MultiMap parentToConfig = new MultiMap();
        for (VirtualFile file : files) {
            VirtualFile parent = file.getParent();
            if (parent == null || (parent = parent.getParent()) == null) continue;
            parentToConfig.putValue((Object)parent, (Object)file);
        }
        VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection((Collection)parentToConfig.keySet());
        VirtualFile potentialConfigParent = null;
        for (VirtualFile root : roots) {
            if (parentToConfig.get((Object)root).size() != 1 || "vendor".equals(root.getName())) continue;
            if (potentialConfigParent != null) {
                return null;
            }
            potentialConfigParent = root;
        }
        return potentialConfigParent == null ? null : (VirtualFile)parentToConfig.get(potentialConfigParent).iterator().next();
    }

    @Nullable
    public static VirtualFile getParentFolder(@NotNull Project project) {
        ProjectRootManager instance;
        VirtualFile[] roots;
        VirtualFile parentFolder;
        if (project == null) {
            ComposerInitSupportAction.$$$reportNull$$$0(2);
        }
        if ((parentFolder = project.getBaseDir()) == null && (roots = (instance = ProjectRootManager.getInstance((Project)project)).getContentSourceRoots()).length > 0) {
            parentFolder = roots[0];
        }
        if (parentFolder == null) {
            return null;
        }
        return parentFolder;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ComposerInitSupportAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerInitSupportAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerInitSupportAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentFolder";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

