/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerConfigurationDialog;
import com.jetbrains.php.composer.ComposerPathForm;
import com.jetbrains.php.composer.ComposerSynchronizationInitListener;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.ComposerExecutionProvider;
import com.jetbrains.php.composer.execution.UnknownComposerExecution;
import com.jetbrains.php.composer.execution.executable.ExecutableComposerExecution;
import com.jetbrains.php.composer.execution.phar.PharComposerExecution;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.io.File;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ComposerSettings", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=true)
public final class ComposerDataService
implements PersistentStateComponent<ComposerState>,
Disposable {
    private final EventDispatcher<ComposerConfigListener> myEventDispatcher;
    private final EventDispatcher<ComposerSynchronizationInitListener> mySyncInitEventDispatcher;
    private static final Logger LOG = Logger.getInstance(ComposerDataService.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private ComposerExecution myExecution;
    private String myConfigPath;
    private boolean myUpdateLibrary;
    private boolean myDoNotAskAgain;
    private SynchronizationState mySynchronizationState;
    private Map<String, Boolean> myTestFrameworkSyncEnablingMap;
    private boolean myShouldDownloadPhar;
    private final AtomicBoolean myIsDownloading;
    private boolean myLoadUpdateAvailability;
    private boolean myShowQuickActionsPanel;
    private boolean myNotifyAboutMissingVendor;
    private boolean myRequirePlatformReqs;

    public static ComposerDataService getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerDataService.$$$reportNull$$$0(0);
        }
        return (ComposerDataService)project.getService(ComposerDataService.class);
    }

    public ComposerDataService(@NotNull Project project) {
        if (project == null) {
            ComposerDataService.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher = EventDispatcher.create(ComposerConfigListener.class);
        this.mySyncInitEventDispatcher = EventDispatcher.create(ComposerSynchronizationInitListener.class);
        this.myExecution = ComposerExecution.DEFAULT;
        this.myUpdateLibrary = true;
        this.mySynchronizationState = SynchronizationState.NOT_INITIALIZED;
        this.myTestFrameworkSyncEnablingMap = Arrays.stream(PhpTestFrameworkType.getTestFrameworkTypes()).collect(Collectors.toMap(PhpTestFrameworkType::getID, frameworkType -> true));
        this.myShouldDownloadPhar = false;
        this.myIsDownloading = new AtomicBoolean(false);
        this.myLoadUpdateAvailability = true;
        this.myShowQuickActionsPanel = true;
        this.myNotifyAboutMissingVendor = true;
        this.myRequirePlatformReqs = false;
        this.myProject = project;
        ComposerExecutionProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ComposerExecutionProvider>(){

            public void extensionAdded(@NotNull ComposerExecutionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                ComposerExecution execution;
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ComposerDataService.this.myExecution instanceof UnknownComposerExecution && (execution = extension.loadExecution(ComposerDataService.this.myExecution.save())) != null) {
                    ComposerDataService.this.myExecution = execution;
                }
            }

            public void extensionRemoved(@NotNull ComposerExecutionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (extension.isMyExecution(ComposerDataService.this.myExecution)) {
                    ComposerDataService.this.myExecution = new UnknownComposerExecution(ComposerDataService.this.myExecution.save());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/composer/ComposerDataService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            for (VFileEvent event : events) {
                if (!event.getPath().equals(this.myConfigPath)) continue;
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        ComposerDataService.this.configContentChanged();
                    }
                };
            }
            return null;
        }, (Disposable)this);
    }

    @NotNull
    public ComposerExecution getComposerExecution() {
        ComposerExecution composerExecution = this.myExecution;
        if (composerExecution == null) {
            ComposerDataService.$$$reportNull$$$0(2);
        }
        return composerExecution;
    }

    public void setComposerExecution(@NotNull ComposerExecution execution) {
        if (execution == null) {
            ComposerDataService.$$$reportNull$$$0(3);
        }
        this.myExecution = execution;
        if (execution instanceof PharComposerExecution) {
            this.setShouldDownloadPhar(((PharComposerExecution)execution).isShouldDownload());
        } else {
            this.setShouldDownloadPhar(false);
        }
    }

    @Deprecated
    @NlsSafe
    public String getConfigPath() {
        return this.myConfigPath;
    }

    public void setConfigPathAndLibraryUpdateStatus(String configPath, boolean updateLibrary) {
        String oldPath = this.myConfigPath;
        this.myConfigPath = configPath;
        boolean oldStatus = this.myUpdateLibrary;
        LOG.trace("changing updateLibrary value to " + updateLibrary + " for project " + String.valueOf(this.myProject));
        this.myUpdateLibrary = updateLibrary;
        if (!StringUtil.equals((CharSequence)oldPath, (CharSequence)this.myConfigPath)) {
            this.configPathChanged(oldPath, this.myConfigPath);
            if (oldPath == null) {
                this.configContentChanged();
            }
        }
        if (!StringUtil.equals((CharSequence)oldPath, (CharSequence)this.myConfigPath) || oldStatus != this.myUpdateLibrary) {
            ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).configPathOrLibraryStatusChanged(oldStatus, this.myUpdateLibrary);
        }
    }

    private void configContentChanged() {
        ComposerUtils.COMPOSER_CONFIG_EXECUTOR.execute(() -> ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).configContentChanged(this.composerConfigRequiresPhp()));
    }

    @ApiStatus.Internal
    public void configPathChanged(String oldPath, String newPath) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).configPathChanged(oldPath, newPath, ComposerDataService.isWellConfigured(newPath));
        } else {
            ComposerUtils.COMPOSER_CONFIG_EXECUTOR.execute(() -> ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).configPathChanged(oldPath, newPath, ComposerDataService.isWellConfigured(newPath)));
        }
    }

    public boolean composerConfigRequiresPhp() {
        return this.isConfigWellConfigured() && ComposerConfigUtils.requiresPhp(this.getConfigFile());
    }

    public boolean isUpdateLibrary() {
        return this.myUpdateLibrary;
    }

    public boolean isTestFrameworkSyncEnabled(@NotNull PhpTestFrameworkType testFrameworkType) {
        if (testFrameworkType == null) {
            ComposerDataService.$$$reportNull$$$0(4);
        }
        return this.myTestFrameworkSyncEnablingMap.getOrDefault(testFrameworkType.getID(), false);
    }

    public void setIsTestFrameworkSyncEnabled(PhpTestFrameworkType testFrameworkType, boolean isEnabled) {
        this.myTestFrameworkSyncEnablingMap.put(testFrameworkType.getID(), isEnabled);
    }

    public void resetTestFrameworkSyncEnablingMap() {
        this.myTestFrameworkSyncEnablingMap.replaceAll((testFrameworkId, oldIsEnabled) -> true);
    }

    public boolean isLoadUpdateAvailability() {
        return this.myLoadUpdateAvailability;
    }

    public void setLoadUpdateAvailability(boolean loadUpdateAvailability) {
        boolean oldStatus = this.myLoadUpdateAvailability;
        this.myLoadUpdateAvailability = loadUpdateAvailability;
        if (oldStatus != this.myLoadUpdateAvailability) {
            ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).loadUpdateAvailabilityStatusChanged();
        }
    }

    public boolean isRequirePlatformReqs() {
        return this.myRequirePlatformReqs;
    }

    public void setRequirePlatformReqs(boolean requirePlatformReqs) {
        this.myRequirePlatformReqs = requirePlatformReqs;
    }

    public boolean isShowQuickActionsPanel() {
        return this.myShowQuickActionsPanel;
    }

    public void setShowQuickActionsPanel(boolean showQuickActionsPanel) {
        this.myShowQuickActionsPanel = showQuickActionsPanel;
    }

    public boolean isNotifyAboutMissingVendor() {
        return this.myNotifyAboutMissingVendor;
    }

    public void setNotifyAboutMissingVendor(boolean notifyAboutMissingVendor) {
        this.myNotifyAboutMissingVendor = notifyAboutMissingVendor;
        ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).notifyAboutMissingVendorChanged(notifyAboutMissingVendor);
    }

    @NotNull
    public SynchronizationState getSynchronizationState() {
        SynchronizationState synchronizationState = this.mySynchronizationState;
        if (synchronizationState == null) {
            ComposerDataService.$$$reportNull$$$0(5);
        }
        return synchronizationState;
    }

    public void setSynchronizationState(@NotNull SynchronizationState synchronizationState) {
        if (synchronizationState == null) {
            ComposerDataService.$$$reportNull$$$0(6);
        }
        SynchronizationState oldState = this.mySynchronizationState;
        this.mySynchronizationState = synchronizationState;
        if (oldState != this.mySynchronizationState) {
            ((ComposerSynchronizationInitListener)this.mySyncInitEventDispatcher.getMulticaster()).syncInitialized(this.mySynchronizationState);
        }
    }

    public void addConfigListener(ComposerConfigListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    public void removeConfigListener(ComposerConfigListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public void addSynchronizationInitListener(@NotNull ComposerSynchronizationInitListener listener) {
        if (listener == null) {
            ComposerDataService.$$$reportNull$$$0(7);
        }
        this.mySyncInitEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    public void removeSynchronizationInitListener(@NotNull ComposerSynchronizationInitListener listener) {
        if (listener == null) {
            ComposerDataService.$$$reportNull$$$0(8);
        }
        this.mySyncInitEventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isExecutionWellConfigured(boolean quick) {
        return this.myExecution.isWellConfigured(this.myProject, quick);
    }

    public boolean isConfigWellConfigured() {
        return ComposerDataService.isWellConfigured(this.myConfigPath);
    }

    public static boolean isWellConfigured(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public boolean syncLanguageLevel() {
        return this.mySynchronizationState.equals((Object)SynchronizationState.SYNCHRONIZE) && this.composerConfigRequiresPhp();
    }

    @Nullable
    public VirtualFile getConfigFile() {
        return this.myConfigPath == null ? null : VfsUtil.findFileByIoFile((File)new File(this.myConfigPath), (boolean)true);
    }

    @NotNull
    public ComposerState getState() {
        Element rootElement = new Element("root");
        Element child = this.myExecution.save();
        if (!JDOMUtil.isEmpty((Element)child)) {
            rootElement.addContent(child);
        }
        LOG.trace("Getting ComposerState for: " + String.valueOf(this));
        return new ComposerState(this.myConfigPath, this.myUpdateLibrary, this.myDoNotAskAgain, this.mySynchronizationState, rootElement, this.myLoadUpdateAvailability, this.myShowQuickActionsPanel, this.myNotifyAboutMissingVendor, this.myRequirePlatformReqs, this.myTestFrameworkSyncEnablingMap);
    }

    public void loadState(@NotNull ComposerState state) {
        if (state == null) {
            ComposerDataService.$$$reportNull$$$0(9);
        }
        this.myConfigPath = state.getConfigPath();
        Element executionElement = state.getExecutionElement();
        if (executionElement != null) {
            this.myExecution = new UnknownComposerExecution(executionElement);
            List children = executionElement.getChildren();
            block0: for (ComposerExecutionProvider provider : ComposerExecutionProvider.getProviders()) {
                for (Element child : children) {
                    ComposerExecution execution = provider.loadExecution(child);
                    if (execution == null) continue;
                    this.myExecution = execution;
                    continue block0;
                }
            }
        } else {
            String executablePath = state.getExecutablePath();
            if (state.getExecutionDataType() == ExecutionDataType.EXECUTABLE) {
                this.myExecution = new ExecutableComposerExecution(executablePath);
            } else {
                String interpreterId = state.getInterpreterId();
                if (interpreterId == null) {
                    interpreterId = ComposerDataService.guessOrCreateInterpreterId(state.getPhpPath(), this.myProject);
                }
                this.myExecution = new PharComposerExecution(interpreterId, StringUtil.notNullize((String)state.getPath()), false);
            }
        }
        this.myUpdateLibrary = state.getUpdatePackages();
        this.mySynchronizationState = state.getSynchronizationState();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
        this.myLoadUpdateAvailability = state.isLoadUpdateAvailability();
        this.myShowQuickActionsPanel = state.isShowQuickActionPanel();
        this.myNotifyAboutMissingVendor = state.isNotifyAboutMissingVendor();
        this.myTestFrameworkSyncEnablingMap = state.getTestFrameworkSyncEnablingMap();
        LOG.trace("ComposerState loaded: " + String.valueOf(this));
    }

    @Nullable
    private static String guessOrCreateInterpreterId(String phpPath, @NotNull Project project) {
        if (project == null) {
            ComposerDataService.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)phpPath)) {
            return null;
        }
        HashSet<String> interpreterNames = new HashSet<String>();
        PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
        List<PhpInterpreter> interpreters = interpretersManager.getInterpreters();
        for (PhpInterpreter interpreter : interpreters) {
            if (interpreter.isRemote()) continue;
            interpreterNames.add(interpreter.getName());
            String executable = interpreter.getPathToPhpExecutable();
            if (!FileUtil.pathsEqual((String)phpPath, (String)executable)) continue;
            return interpreter.getId();
        }
        String baseName = PhpBundle.message("framework.composer.default.composer.interpreter.name", new Object[0]);
        int index = 0;
        Object name = baseName;
        while (interpreterNames.contains(name)) {
            name = baseName + " (" + ++index + ")";
        }
        PhpInterpreter interpreter = new PhpInterpreter();
        interpreter.setIsProjectLevel(true);
        interpreter.setHomePath(FileUtil.toSystemDependentName((String)phpPath));
        interpreter.setName((String)name);
        interpreters.add(interpreter);
        interpretersManager.setInterpreters(interpreters);
        return interpreter.getId();
    }

    public boolean askForValidConfigurationIfNeeded() {
        if (this.isExecutionWellConfigured(false)) {
            return true;
        }
        if ((this.myExecution instanceof UnknownComposerExecution || this.myExecution == ComposerExecution.DEFAULT) && (ComposerPathForm.validateExecutableFromPath("composer") == null || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            this.setComposerExecution(ComposerExecution.createDefaultExecutableExecution());
            this.showNotification();
            return true;
        }
        return this.showConfigurationDialog() && this.isExecutionWellConfigured(false);
    }

    private boolean showConfigurationDialog() {
        return new ComposerConfigurationDialog(this.myProject, this, false, true).showAndGet();
    }

    private void showNotification() {
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup(ComposerUtils.getComposerGroupDisplayId()).createNotification(PhpBundle.message("notification.content.composer.executable.was.automatically.set.to.global.composer", new Object[0]), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.create((String)PhpBundle.message("notification.content.configure.manually", new Object[0]), (e, n) -> {
            notification.expire();
            this.showConfigurationDialog();
        }));
        notification.notify(this.myProject);
    }

    public void setDoNotAskAgain(boolean doNotAskAgain) {
        this.myDoNotAskAgain = doNotAskAgain;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    private void setShouldDownloadPhar(boolean shouldDownloadPhar) {
        if (!shouldDownloadPhar) {
            this.myShouldDownloadPhar = false;
            this.myIsDownloading.set(false);
            return;
        }
        if (this.myShouldDownloadPhar) {
            return;
        }
        this.myShouldDownloadPhar = true;
        if (this.myIsDownloading.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ComposerExecution execution;
                if (!this.myIsDownloading.get()) {
                    return;
                }
                VirtualFile file = ComposerUtils.downloadPhar(this.myProject, null, this.myProject.getBaseDir().getPath());
                if (file != null && (execution = this.getComposerExecution()) instanceof PharComposerExecution) {
                    ((PharComposerExecution)execution).setShouldDownload(false);
                    ((PharComposerExecution)execution).setPharPath(file.getPath());
                }
                this.myIsDownloading.set(false);
                this.myShouldDownloadPhar = false;
            }, ModalityState.nonModal());
        }
    }

    @Nullable
    public VirtualFile getCurrentConfigFile() {
        String path = this.getConfigPath();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public void dispose() {
    }

    public String toString() {
        return "ComposerDataService{myProject=" + String.valueOf(this.myProject) + ", myExecution=" + String.valueOf(this.myExecution) + ", myConfigPath='" + this.myConfigPath + "', myUpdateLibrary=" + this.myUpdateLibrary + ", myDoNotAskAgain=" + this.myDoNotAskAgain + ", mySynchronizationState=" + String.valueOf((Object)this.mySynchronizationState) + ", myShouldDownloadPhar=" + this.myShouldDownloadPhar + ", myIsDownloading=" + String.valueOf(this.myIsDownloading) + ", myLoadUpdateAvailability=" + this.myLoadUpdateAvailability + ", myShowQuickActionsPanel=" + this.myShowQuickActionsPanel + ", myNotifyAboutMissingVendor=" + this.myNotifyAboutMissingVendor + ", myRequirePlatformReqs=" + this.myRequirePlatformReqs + ", myTestFrameworkSyncEnablingMap=" + String.valueOf(this.myTestFrameworkSyncEnablingMap) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerDataService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synchronizationState";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerDataService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposerExecution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizationState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setComposerExecution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkSyncEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSynchronizationState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSynchronizationInitListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeSynchronizationInitListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessOrCreateInterpreterId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    public static enum SynchronizationState {
        NOT_INITIALIZED,
        SYNCHRONIZE,
        DONT_SYNCHRONIZE;

    }

    @Tag(value="composer")
    public static class ComposerState {
        private String myPath;
        private String myConfigPath;
        private String myPhpPath;
        private String myInterpreterId;
        private String myExecutablePath;
        private boolean myUpdatePackages;
        private SynchronizationState mySynchronizationState;
        private boolean myDoNotAskAgain;
        private ExecutionDataType myExecutionDataType;
        private Element myExecutionElement;
        private boolean myLoadUpdateAvailability;
        private boolean myShowQuickActionPanel;
        private boolean myNotifyAboutMissingVendor;
        private boolean myRequirePlatformReqs;
        private Map<String, Boolean> myTestFrameworkSyncEnablingMap;

        public ComposerState(String configPath, boolean updatePackages, boolean doNotAskAgain, @NotNull SynchronizationState synchronizationState, @Nullable Element executionElement, boolean loadUpdateAvailability, boolean showQuickActionsPanel, boolean notifyAboutMissingVendor, boolean requirePlatformReqs, Map<String, Boolean> testFrameworkSyncEnablingMap) {
            if (synchronizationState == null) {
                ComposerState.$$$reportNull$$$0(0);
            }
            this.myExecutionDataType = ExecutionDataType.EXECUTABLE;
            this.myConfigPath = configPath;
            this.myUpdatePackages = updatePackages;
            this.mySynchronizationState = synchronizationState;
            this.myDoNotAskAgain = doNotAskAgain;
            this.myExecutionElement = executionElement;
            this.myLoadUpdateAvailability = loadUpdateAvailability;
            this.myShowQuickActionPanel = showQuickActionsPanel;
            this.myNotifyAboutMissingVendor = notifyAboutMissingVendor;
            this.myRequirePlatformReqs = requirePlatformReqs;
            this.myTestFrameworkSyncEnablingMap = testFrameworkSyncEnablingMap;
        }

        public ComposerState() {
            this(null, true, false, SynchronizationState.NOT_INITIALIZED, null, true, true, true, false, Arrays.stream(PhpTestFrameworkType.getTestFrameworkTypes()).collect(Collectors.toMap(PhpTestFrameworkType::getID, frameworkType -> true)));
            LOG.trace("Default ComposerState created");
        }

        @Tag(value="pharPath")
        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        @Tag(value="pharConfigPath")
        public String getConfigPath() {
            return this.myConfigPath;
        }

        public void setConfigPath(String configPath) {
            this.myConfigPath = configPath;
        }

        @Tag(value="phpPath")
        public String getPhpPath() {
            return this.myPhpPath;
        }

        public void setPhpPath(String phpPath) {
            this.myPhpPath = phpPath;
        }

        @Tag(value="executablePath")
        public String getExecutablePath() {
            return this.myExecutablePath;
        }

        public void setExecutablePath(String executablePath) {
            this.myExecutablePath = executablePath;
        }

        @Attribute(value="updatePackages")
        public boolean getUpdatePackages() {
            return this.myUpdatePackages;
        }

        public void setUpdatePackages(boolean updatePackages) {
            LOG.trace("setting update packages to " + updatePackages);
            this.myUpdatePackages = updatePackages;
        }

        @Attribute(value="synchronizationState")
        public SynchronizationState getSynchronizationState() {
            return this.mySynchronizationState;
        }

        public void setSynchronizationState(@NotNull SynchronizationState synchronizationState) {
            if (synchronizationState == null) {
                ComposerState.$$$reportNull$$$0(1);
            }
            this.mySynchronizationState = synchronizationState;
        }

        @Attribute(value="phpInterpreterId")
        public String getInterpreterId() {
            return this.myInterpreterId;
        }

        public void setInterpreterId(String interpreterId) {
            this.myInterpreterId = interpreterId;
        }

        @Attribute(value="doNotAsk")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="executionDataType")
        public ExecutionDataType getExecutionDataType() {
            return this.myExecutionDataType;
        }

        public void setExecutionDataType(ExecutionDataType executionDataType) {
            this.myExecutionDataType = executionDataType;
        }

        @Tag(value="execution")
        public Element getExecutionElement() {
            return this.myExecutionElement;
        }

        public void setExecutionElement(Element execution) {
            this.myExecutionElement = execution;
        }

        @Attribute(value="loadUpdateAvailability")
        public boolean isLoadUpdateAvailability() {
            return this.myLoadUpdateAvailability;
        }

        public void setLoadUpdateAvailability(boolean loadUpdateAvailability) {
            this.myLoadUpdateAvailability = loadUpdateAvailability;
        }

        @Attribute(value="showQuickActionsPanel")
        public boolean isShowQuickActionPanel() {
            return this.myShowQuickActionPanel;
        }

        public void setShowQuickActionPanel(boolean showQuickActionPanel) {
            this.myShowQuickActionPanel = showQuickActionPanel;
        }

        @Attribute(value="notifyAboutMissingVendor")
        public boolean isNotifyAboutMissingVendor() {
            return this.myNotifyAboutMissingVendor;
        }

        public void setNotifyAboutMissingVendor(boolean notifyAboutMissingVendor) {
            this.myNotifyAboutMissingVendor = notifyAboutMissingVendor;
        }

        @Attribute(value="requirePlatformReqs")
        public boolean isRequirePlatformReqs() {
            return this.myRequirePlatformReqs;
        }

        public void setRequirePlatformReqs(boolean requirePlatformReqs) {
            this.myRequirePlatformReqs = requirePlatformReqs;
        }

        @Tag(value="testFrameworkAndSyncEnablingMap")
        @MapAnnotation(entryTagName="testFrameworkAndSyncEnabling", keyAttributeName="testFramework", valueAttributeName="syncEnabling", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, Boolean> getTestFrameworkSyncEnablingMap() {
            return this.myTestFrameworkSyncEnablingMap;
        }

        public void setTestFrameworkSyncEnablingMap(Map<String, Boolean> testFrameworkSyncEnablingMap) {
            this.myTestFrameworkSyncEnablingMap = testFrameworkSyncEnablingMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "synchronizationState";
            objectArray2[1] = "com/jetbrains/php/composer/ComposerDataService$ComposerState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSynchronizationState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ExecutionDataType {
        EXECUTABLE,
        PHAR;

    }
}

