/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.expectedArguments;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionClassConstantArgumentLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionConstantArgumentLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionScalarArgumentLookupElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpExpectedFunctionArgumentLookupElement {
    public static final Condition<? super PsiElement> ELEMENT_CAN_BE_EXPECTED_ARGUMENT = e -> e instanceof ConstantReference || e instanceof ClassConstantReference || e instanceof Variable || e instanceof StringLiteralExpression || PhpPsiUtil.isOfType(e, PhpElementTypes.NUMBER);

    @Nullable
    public static LookupElement create(Project project, PsiElement parameter, @NotNull PhpExpectedFunctionArgument argument) {
        PhpNamedElement element;
        if (argument == null) {
            PhpExpectedFunctionArgumentLookupElement.$$$reportNull$$$0(0);
        }
        if ((element = argument.getNamedElement(project)) instanceof Field && ((Field)element).isConstant() || element instanceof PhpEnumCase) {
            return new PhpExpectedFunctionClassConstantArgumentLookupElement((PhpClassMember)element, argument.getOrder(), parameter instanceof ClassConstantReference);
        }
        if (element instanceof Constant) {
            return new PhpExpectedFunctionConstantArgumentLookupElement((Constant)element, argument.getOrder());
        }
        if (argument instanceof PhpExpectedFunctionScalarArgument) {
            PhpExpectedFunctionScalarArgument scalarArgument = (PhpExpectedFunctionScalarArgument)argument;
            return new PhpExpectedFunctionScalarArgumentLookupElement(argument.getValue(), argument.getOrder(), PhpExpectedFunctionArgumentLookupElement.isInsideStringLiteral(parameter), scalarArgument.isStringLiteral(), scalarArgument.getType());
        }
        return null;
    }

    public int getOrder();

    public static boolean accept(PhpExpectedFunctionArgument argument, PsiElement parameter) {
        return PhpExpectedFunctionArgumentLookupElement.isInsideStringLiteral(parameter) && PhpPsiUtil.isOfType(parameter, PhpTokenTypes.STRING_LITERAL) || parameter instanceof ConstantReference || PhpExpectedFunctionArgumentLookupElement.createValidParameterPredicate(argument).test(parameter);
    }

    private static boolean isInsideStringLiteral(PsiElement parameter) {
        return PhpPsiUtil.getParentOfClass(parameter, false, StringLiteralExpression.class) != null;
    }

    public static Predicate<PsiElement> createValidParameterPredicate(PhpExpectedFunctionArgument argument) {
        if (argument instanceof PhpExpectedFunctionScalarArgument) {
            boolean isStringLiteral = ((PhpExpectedFunctionScalarArgument)argument).isStringLiteral();
            return p -> isStringLiteral ? p instanceof StringLiteralExpression : PhpPsiUtil.isOfType(p, PhpElementTypes.NUMBER);
        }
        if (argument instanceof PhpExpectedFunctionConstantArgument) {
            return ConstantReference.class::isInstance;
        }
        return e -> {
            PhpExpression reference;
            if (e instanceof ClassConstantReference && (reference = ((ClassConstantReference)e).getClassReference()) instanceof ClassReference) {
                return PhpLangUtil.equalsClassNames(((ClassReference)reference).getFQN(), ((PhpExpectedFunctionClassConstantArgument)argument).getClassFqn());
            }
            return false;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/php/completion/expectedArguments/PhpExpectedFunctionArgumentLookupElement", "create"));
    }
}

