/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.liveTemplates.macro.PhpSuggestFunctionParameterMacro;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpSmartFunctionParametersLookupElement
extends LookupElement {
    @NonNls
    public static final String TEMPLATE_NAME = "params";
    private final LiveTemplateLookupElement delegate;

    public PhpSmartFunctionParametersLookupElement(@NotNull Function function) {
        if (function == null) {
            PhpSmartFunctionParametersLookupElement.$$$reportNull$$$0(0);
        }
        this.delegate = new LiveTemplateLookupElementImpl(PhpSmartFunctionParametersLookupElement.getTemplate(function), true);
    }

    public static TemplateImpl getTemplate(@NotNull Function function) {
        if (function == null) {
            PhpSmartFunctionParametersLookupElement.$$$reportNull$$$0(1);
        }
        Parameter[] parameters = function.getParameters();
        int length = parameters.length;
        for (int i = length - 1; i >= 0 && parameters[i].isOptional(); --i) {
            --length;
        }
        StringBuilder string = new StringBuilder(length * 7);
        for (int i = 0; i < length; ++i) {
            string.append("$VAR").append(i).append('$');
            if (i + 1 >= length) continue;
            string.append(',');
        }
        TemplateImpl template = new TemplateImpl(TEMPLATE_NAME, string.toString(), "PHP");
        template.setDescription(PhpBundle.message("template.smart.completion.function.parameters.description", new Object[0]));
        template.setToReformat(true);
        for (int i = 0; i < length; ++i) {
            Parameter parameter = parameters[i];
            PhpPredefinedSuggestFunctionParameterMacro macro = new PhpPredefinedSuggestFunctionParameterMacro(parameter.getName());
            template.addVariable("VAR" + i, (Expression)new MacroCallNode((Macro)macro), (Expression)new ConstantNode(""), true);
        }
        return template;
    }

    @NotNull
    public String getLookupString() {
        String string = this.delegate.getLookupString();
        if (string == null) {
            PhpSmartFunctionParametersLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            PhpSmartFunctionParametersLookupElement.$$$reportNull$$$0(3);
        }
        this.delegate.renderElement(presentation);
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.delegate.getAutoCompletionPolicy();
    }

    public boolean isWorthShowingInAutoPopup() {
        return this.delegate.isWorthShowingInAutoPopup();
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpSmartFunctionParametersLookupElement.$$$reportNull$$$0(4);
        }
        this.delegate.handleInsert(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpSmartFunctionParametersLookupElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpSmartFunctionParametersLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class PhpPredefinedSuggestFunctionParameterMacro
    extends PhpSuggestFunctionParameterMacro {
        private final String myParameterName;

        private PhpPredefinedSuggestFunctionParameterMacro(@NotNull String parameterName) {
            if (parameterName == null) {
                PhpPredefinedSuggestFunctionParameterMacro.$$$reportNull$$$0(0);
            }
            this.myParameterName = parameterName;
        }

        @Override
        @NotNull
        protected String getParameterName(@NotNull ExpressionContext context) {
            if (context == null) {
                PhpPredefinedSuggestFunctionParameterMacro.$$$reportNull$$$0(1);
            }
            String string = this.myParameterName;
            if (string == null) {
                PhpPredefinedSuggestFunctionParameterMacro.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpSmartFunctionParametersLookupElement$PhpPredefinedSuggestFunctionParameterMacro";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpSmartFunctionParametersLookupElement$PhpPredefinedSuggestFunctionParameterMacro";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

