/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpCompletionSorting;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class PhpNamedArgumentsCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PhpNamedArgumentsCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpTokenTypes.IDENTIFIER).withParent(ConstantReference.class)).withSuperParent(2, ParameterList.class)).withSuperParent(3, ParameterListOwner.class), new PhpNamedArgumentsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpTokenTypes.IDENTIFIER).withParent(ParameterList.class)).withSuperParent(2, ParameterListOwner.class), new PhpNamedArgumentsCompletionProvider());
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpNamedArgumentsCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PhpNamedArgumentsCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, PhpCompletionSorting.addPhpSorting(parameters, result));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/completion/PhpNamedArgumentsCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PhpNamedArgumentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NotNull
        private static final TokenSet POSSIBLE_NAMED_ARGUMENT_PART = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOLON, PhpTokenTypes.IDENTIFIER});

        PhpNamedArgumentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpNamedArgumentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpNamedArgumentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpNamedArgumentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!PhpLanguageFeature.NAMED_ARGUMENTS.isSupported((position = parameters.getPosition()).getProject())) {
                return;
            }
            if (PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(position.getParent(), true), POSSIBLE_NAMED_ARGUMENT_PART)) {
                return;
            }
            boolean myAmendColon = !PhpNamedArgumentsCompletionProvider.isIdentifierBeforeColon(parameters.getOriginalPosition()) && !PhpNamedArgumentsCompletionProvider.isIdentifierBeforeColon(parameters.getPosition());
            ParameterListOwner parameterListOwner = PhpPsiUtil.getParentOfClass(position.getOriginalElement(), ParameterListOwner.class);
            if (parameterListOwner == null) {
                return;
            }
            Collection<Function> functions = PhpAnnotatorVisitor.resolveFunctions(parameterListOwner);
            PsiElement[] arguments = parameterListOwner.getParameters();
            int currentIndex = PhpCodeInsightUtil.getParameterIndex(position.getParent());
            for (Function function : functions) {
                Parameter[] functionParameters = function.getParameters();
                Set usedArgumentNames = IntStream.range(0, arguments.length).mapToObj(i -> i != currentIndex ? PhpNamedArgumentsCompletionProvider.getArgumentName(arguments, functionParameters, i) : null).filter(Objects::nonNull).collect(Collectors.toCollection(() -> CollectionFactory.createCaseInsensitiveStringSet()));
                for (Parameter parameter : functionParameters) {
                    String name = parameter.getName();
                    if (usedArgumentNames.contains(name)) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)(myAmendColon ? name + ": " : name)));
                }
            }
            if (parameters.getInvocationCount() <= 1 && currentIndex > 0 && arguments.length > 0 && ParameterListImpl.getNameIdentifier(arguments[currentIndex - 1]) != null) {
                result.stopHere();
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
        }

        private static boolean isIdentifierBeforeColon(PsiElement position) {
            return PhpPsiUtil.isOfType(position, PhpTokenTypes.IDENTIFIER) && PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(position, true), PhpTokenTypes.opCOLON);
        }

        private static String getArgumentName(PsiElement[] arguments, Parameter[] functionParameters, int i) {
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments[i]);
            return nameIdentifier != null ? nameIdentifier.getText() : (i < functionParameters.length ? functionParameters[i].getName() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpNamedArgumentsCompletionContributor$PhpNamedArgumentsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

