/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.PhpNoReturnProvider;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAliasedTraitMethodNamesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNeverReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNonNeverReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNeverReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNonNeverReturnTypeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNeverTypedNoReturnProvider
implements PhpNoReturnProvider {
    public boolean isCustomNoReturn(@NotNull FunctionReference functionCall) {
        if (functionCall == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(0);
        }
        if (!PhpNeverTypedNoReturnProvider.neverTypedFunctionWithNameExists(functionCall) && PhpNeverTypedNoReturnProvider.nonNeverTypedFunctionWithNameExists(functionCall)) {
            return false;
        }
        return PhpType.globalTypeEquals((Project)functionCall.getProject(), (PhpType)functionCall.getType(), (PhpType)PhpType.NEVER);
    }

    public static boolean neverTypedFunctionWithNameExists(@NotNull FunctionReference functionCall) {
        if (functionCall == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(1);
        }
        return PhpNeverTypedNoReturnProvider.functionWithNameExistsInStubIndex(functionCall, PhpMethodNeverReturnTypeIndex.KEY, PhpFunctionNeverReturnTypeIndex.KEY);
    }

    public static boolean nonNeverTypedFunctionWithNameExists(@NotNull FunctionReference functionCall) {
        if (functionCall == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(2);
        }
        return PhpNeverTypedNoReturnProvider.functionWithNameExistsInStubIndex(functionCall, PhpMethodNonNeverReturnTypeIndex.KEY, PhpFunctionNonNeverReturnTypeIndex.KEY);
    }

    public static boolean functionWithNameExistsInStubIndex(@NotNull FunctionReference functionCall, StubIndexKey<String, Method> methodKey, StubIndexKey<String, Function> functionKey) {
        if (functionCall == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(3);
        }
        if (functionCall instanceof MethodReference) {
            return PhpNeverTypedNoReturnProvider.isFunctionWithStubKeyExists(functionCall.getProject(), functionCall.getName(), methodKey, Method.class);
        }
        return PhpNeverTypedNoReturnProvider.isFunctionWithStubKeyExists(functionCall.getProject(), functionCall.getName(), functionKey, Function.class);
    }

    public static <T extends Function> boolean isFunctionWithStubKeyExists(@NotNull Project project, @Nullable String functionName, StubIndexKey<String, T> key, Class<T> clazz) {
        String name;
        if (project == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(4);
        }
        if ((name = StringUtil.toLowerCase((String)functionName)) == null) {
            return false;
        }
        if (PhpNeverTypedNoReturnProvider.isFunctionExists(project, key, clazz, name).booleanValue()) {
            return true;
        }
        return clazz == Method.class && ContainerUtil.exists(PhpAliasedTraitMethodNamesIndex.getAliasedMethodNames(project, name), methodName -> PhpNeverTypedNoReturnProvider.isFunctionExists(project, key, clazz, methodName));
    }

    private static <T extends Function> Boolean isFunctionExists(@NotNull Project project, StubIndexKey<String, T> key, Class<T> clazz, String name) {
        if (project == null) {
            PhpNeverTypedNoReturnProvider.$$$reportNull$$$0(5);
        }
        Ref functionExists = new Ref((Object)false);
        StubIndex.getInstance().processElements(key, (Object)name, project, GlobalSearchScope.allScope((Project)project), clazz, m -> {
            functionExists.set((Object)true);
            return false;
        });
        return (Boolean)functionExists.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpNeverTypedNoReturnProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomNoReturn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "neverTypedFunctionWithNameExists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nonNeverTypedFunctionWithNameExists";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "functionWithNameExistsInStubIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionWithStubKeyExists";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

