/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowCacheUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowException;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpClassDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFinallyHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFirstClassCallableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpForLoopHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLoopHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpThrowInterruptionInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpInstructionExplicitStopListener;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpControlFlowUtil {
    private static final Logger LOG = Logger.getInstance(PhpControlFlowUtil.class);
    private static final Key<Map<String, Boolean>> ALWAYS_NON_EMPTY_ARRAY = Key.create((String)"php.array.always.non.empty");
    private static final Key<Map<String, Boolean>> HAS_REF_ACCESS = Key.create((String)"php.has.ref.access");
    private static final AppendPredecessorsStrategy ALL_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber, predecessors) -> {
        PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber, predecessors) -> {
        int num = instruction.num();
        PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (num <= predecessor.num() || PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = new MyIgnoreInitialBackEdgesAppendPredecessorsStrategy();
    private static final AppendPredecessorsStrategy IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY_WITHOUT_CHECKS = new MyIgnoreInitialBackEdgesAppendPredecessorsStrategy(){

        @Override
        protected boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skippedLoopInstruction, PhpInstruction predecessor) {
            return false;
        }
    };

    private PhpControlFlowUtil() {
    }

    public static boolean alwaysNonEmptyArray(PhpInstruction instruction, final String arrayName) {
        boolean res;
        PhpScopeHolder holder = PhpPsiUtil.getScopeHolder(instruction.getAnchor());
        if (!ContainerUtil.exists((Iterable)PhpControlFlowUtil.getPotentialNonEmptyVariableNames(holder).get((Object)arrayName), i -> instruction.num() >= i)) {
            return false;
        }
        final Ref alwaysNonEmpty = new Ref((Object)Boolean.FALSE);
        final Ref ambiguity = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessors(instruction, false, IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY_WITHOUT_CHECKS, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                Boolean previouslyComputedResult = PhpControlFlowCacheUtil.tryFetchPreviouslyComputedResultFromCache(instruction, arrayName, ALWAYS_NON_EMPTY_ARRAY);
                if (previouslyComputedResult != null) {
                    alwaysNonEmpty.set((Object)previouslyComputedResult);
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!super.processAccessVariableInstruction(instruction)) {
                    return false;
                }
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), arrayName)) {
                    return true;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access instanceof PhpAccessInstruction.ReadOrReadRefAccess) {
                    ambiguity.set((Object)Boolean.TRUE);
                    return false;
                }
                if (access.isWrite()) {
                    if (PhpControlFlowUtil.nonEmptyElement(((PhpAccessVariableInstructionImpl)instruction).getAssignedValue())) {
                        alwaysNonEmpty.set((Object)Boolean.TRUE);
                    } else {
                        ambiguity.set((Object)Boolean.TRUE);
                    }
                    return false;
                }
                return true;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (!super.processArrayAccessInstruction(instruction)) {
                    return false;
                }
                if (PhpLangUtil.equalsVariableNames(PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction), arrayName) && instruction.getAccess().isWrite()) {
                    alwaysNonEmpty.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguity.set((Object)Boolean.TRUE);
                return false;
            }
        });
        boolean bl = res = (Boolean)ambiguity.get() == false && (Boolean)alwaysNonEmpty.get() != false;
        if (instruction instanceof PhpInstructionImpl) {
            PhpControlFlowCacheUtil.updateCache(instruction, arrayName, res, ALWAYS_NON_EMPTY_ARRAY);
        }
        return res;
    }

    private static MultiMap<CharSequence, Integer> getPotentialNonEmptyVariableNames(@Nullable PhpScopeHolder holder) {
        if (holder == null) {
            return MultiMap.empty();
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)holder, () -> PhpControlFlowUtil.doGetPotentialNonEmptyVariableNames(holder));
    }

    @NotNull
    private static CachedValueProvider.Result<MultiMap<CharSequence, Integer>> doGetPotentialNonEmptyVariableNames(@NotNull PhpScopeHolder holder) {
        if (holder == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(0);
        }
        final MultiMap potentialNonEmptyVariableNames = MultiMap.create();
        PhpControlFlowUtil.processFlow(holder.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpControlFlowUtil.nonEmptyElement(((PhpAccessVariableInstructionImpl)instruction).getAssignedValue())) {
                    potentialNonEmptyVariableNames.putValue((Object)instruction.getVariableName(), (Object)instruction.num());
                }
                return super.processAccessVariableInstruction(instruction);
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (instruction.getAccess().isWrite()) {
                    potentialNonEmptyVariableNames.putValue((Object)name, (Object)instruction.num());
                }
                return super.processArrayAccessInstruction(instruction);
            }
        });
        CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)potentialNonEmptyVariableNames, (Object[])new Object[]{holder});
        if (result == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(1);
        }
        return result;
    }

    private static boolean nonEmptyElement(@Nullable PsiElement value) {
        if (value instanceof BinaryExpression && ((BinaryExpression)value).getOperationType() == PhpTokenTypes.opPLUS) {
            return PhpControlFlowUtil.nonEmptyElement(((BinaryExpression)value).getLeftOperand()) || PhpControlFlowUtil.nonEmptyElement(((BinaryExpression)value).getRightOperand());
        }
        return value instanceof ArrayCreationExpression && !ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).limit(1).isEmpty();
    }

    public static boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor, PhpInstruction predecessor) {
        return skipLoopPredecessor != null && predecessor == skipLoopPredecessor.getOriginalPredecessor() && PhpControlFlowUtil.alwaysNonEmptyArray(predecessor, skipLoopPredecessor.getArrayName());
    }

    public static void processSuccessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(3);
        }
        PhpControlFlowUtil.processSuccessors(instruction, visitSelf, processor2, new BitSet());
    }

    public static void processSuccessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(5);
        }
        HashMap<PhpInstruction, PhpInstruction> skippedLoopFalseHostInstruction = new HashMap<PhpInstruction, PhpInstruction>();
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>();
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            PhpControlFlowUtil.appendSuccessors(instruction, instruction, processorPool, skippedLoopFalseHostInstruction);
        }
        int c = 0;
        while (!processorPool.isEmpty()) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visited.get(curInstruction.num())) {
                visited.set(curInstruction.num());
                if (!PhpControlFlowUtil.stopOnThrowInspection(processor2, curInstruction) && curInstruction.process(processor2)) {
                    PhpControlFlowUtil.appendSuccessors(curInstruction, instruction, processorPool, skippedLoopFalseHostInstruction);
                } else if (processor2.shouldHaltTraversal()) {
                    processorPool.clear();
                    return;
                }
            } else if (skippedLoopFalseHostInstruction.containsKey(curInstruction)) {
                processorPool.add((PhpInstruction)skippedLoopFalseHostInstruction.remove(curInstruction));
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 200000) continue;
            throw new PhpControlFlowException("Control flow (Successors) is too big. Initial instruction=" + String.valueOf(instruction) + " Last instruction=" + String.valueOf(curInstruction));
        }
    }

    private static boolean stopOnThrowInspection(PhpInstructionProcessor processor2, PhpInstruction instruction) {
        return instruction instanceof PhpThrowInterruptionInstruction && processor2.stopTraverseOnThrowInterruptingInstruction();
    }

    private static void appendSuccessors(@NotNull PhpInstruction instruction, @NotNull PhpInstruction originalInstruction, Deque<PhpInstruction> processorPool, Map<PhpInstruction, PhpInstruction> skippedLoopFalseHostInstruction) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (originalInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (originalInstruction.num() < instruction.num() && instruction instanceof PhpForLoopHostInstructionImpl && ((PhpForLoopHostInstructionImpl)instruction).conditionExecutedAtLeastOnce()) {
            int prevSize = processorPool.size();
            ((PhpForLoopHostInstructionImpl)instruction).appendSuccessors(processorPool, skippedLoopFalseHostInstruction);
            if (processorPool.size() > prevSize) {
                return;
            }
        }
        instruction.appendSuccessors(processorPool);
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(9);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, ALL_APPEND_PREDECESSOR_STRATEGY, processor2);
    }

    @ApiStatus.Internal
    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(11);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, ALL_APPEND_PREDECESSOR_STRATEGY, processor2, visited);
    }

    public static void processPredecessorsIgnoreBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(13);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor2);
    }

    public static void processPredecessorsIgnoreInitialBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor2) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(15);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor2);
    }

    @ApiStatus.Internal
    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, @NotNull PhpInstructionProcessor processor2) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(18);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, appendPredecessorsStrategy, processor2, new BitSet(instruction.num()));
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, @NotNull PhpInstructionProcessor processor2, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(19);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(21);
        }
        BitSet toSkip = new BitSet(visited.size());
        int initialNumber = instruction.num();
        IntRef mapSize = new IntRef(0);
        MultiMap initialEdgesToSkipInFirstPass = MultiMap.createSet();
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>(50);
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            PhpControlFlowUtil.appendPredecessors(instruction, appendPredecessorsStrategy, initialNumber, processorPool, (MultiMap<PhpInstruction, PhpInstruction>)initialEdgesToSkipInFirstPass, mapSize);
            PhpControlFlowUtil.setAmbiguousPredecessors((PhpInstructionImpl)instruction, processor2, toSkip);
        }
        int c = 0;
        while (!processorPool.isEmpty()) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visitSelf && curInstruction == instruction) {
                processor2.handleSelfInstructionRecurringProcess(instruction, curInstruction);
            }
            if (!visited.get(curInstruction.num())) {
                boolean result;
                visited.set(curInstruction.num());
                boolean bl = result = !PhpControlFlowUtil.stopOnThrowInspection(processor2, curInstruction) && (toSkip.get(curInstruction.num()) || curInstruction.process(processor2));
                if (result && (!((PhpInstructionImpl)curInstruction).isTerminatesAfterFinally() || ((PhpInstructionImpl)instruction).getContainingBlockFinallyHostInstruction() != null)) {
                    PhpControlFlowUtil.appendPredecessors(curInstruction, appendPredecessorsStrategy, initialNumber, processorPool, (MultiMap<PhpInstruction, PhpInstruction>)initialEdgesToSkipInFirstPass, mapSize);
                    PhpControlFlowUtil.setAmbiguousPredecessors((PhpInstructionImpl)curInstruction, processor2, toSkip);
                } else if (!result && processor2 instanceof PhpInstructionExplicitStopListener) {
                    ((PhpInstructionExplicitStopListener)processor2).handleExplicitTraversalTermination();
                }
                if (!result && processor2.shouldHaltTraversal()) {
                    processorPool.clear();
                    return;
                }
                if (curInstruction instanceof PhpFinallyHostInstruction && ((PhpInstructionImpl)instruction).getContainingBlockFinallyHostInstruction() == curInstruction && !((PhpFinallyHostInstruction)curInstruction).haveCatchClauses()) {
                    processorPool.addAll(((PhpFinallyHostInstruction)curInstruction).getInterruptiblePredecessors());
                }
            } else {
                if (curInstruction == instruction) {
                    processor2.handleSelfInstructionRecurringProcess(instruction, curInstruction);
                }
                Collection removed = (Collection)ObjectUtils.notNull((Object)initialEdgesToSkipInFirstPass.remove((Object)curInstruction), Collections::emptySet);
                mapSize.set(mapSize.get() - removed.size());
                processorPool.addAll(removed);
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 200000) continue;
            throw new PhpControlFlowException("Control flow (Predecessors) is too big. Initial instruction=" + String.valueOf(instruction) + " Last instruction=" + String.valueOf(curInstruction));
        }
    }

    private static void appendPredecessors(@NotNull PhpInstruction instruction, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, int initialNumber, Deque<PhpInstruction> processorPool, MultiMap<PhpInstruction, PhpInstruction> initialEdgesToSkipInFirstPass, IntRef mapSize) {
        Collection<Object> instructionsToSkip;
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(23);
        }
        ArrayList predecessors = (ArrayList)instruction.getPredecessors();
        if (instruction instanceof PhpConditionInstruction && !((PhpConditionInstruction)instruction).getResult()) {
            for (PhpInstruction predecessor : predecessors) {
                if (!(predecessor instanceof PhpForLoopHostInstructionImpl) || !((PhpForLoopHostInstructionImpl)predecessor).conditionExecutedAtLeastOnce()) continue;
                PhpInstruction skip = ((PhpForLoopHostInstructionImpl)predecessor).getInitialInstructionToSkip();
                if (initialEdgesToSkipInFirstPass.get((Object)predecessor).contains(skip)) continue;
                mapSize.inc();
                initialEdgesToSkipInFirstPass.putValue((Object)predecessor, (Object)skip);
            }
        }
        Collection<Object> collection = instructionsToSkip = mapSize.get() > 0 ? initialEdgesToSkipInFirstPass.values() : Collections.emptyList();
        if (!instructionsToSkip.isEmpty()) {
            for (PhpInstruction predecessor : predecessors) {
                if (!instructionsToSkip.contains(predecessor)) continue;
                predecessors = new ArrayList(ContainerUtil.subtract((Collection)predecessors, instructionsToSkip));
                break;
            }
        }
        int prevSize = processorPool.size();
        appendPredecessorsStrategy.appendPredecessors(instruction, processorPool, initialNumber, predecessors);
        if (processorPool.size() == prevSize) {
            appendPredecessorsStrategy.appendPredecessors(instruction, processorPool, initialNumber, new ArrayList<Object>(instructionsToSkip));
        }
    }

    private static void setAmbiguousPredecessors(PhpInstructionImpl instruction, @NotNull PhpInstructionProcessor processor2, BitSet toSkip) {
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (processor2.shouldSkipAmbiguousPredecessors()) {
            for (PhpInstruction ambiguousInstruction : instruction.getAmbiguousConditionsInstructions()) {
                toSkip.set(ambiguousInstruction.num());
            }
        }
    }

    public static int processFlow(@NotNull PhpControlFlow controlFlow, @NotNull PhpInstructionProcessor processor2) {
        int i;
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(25);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(26);
        }
        PhpInstruction[] instructions = controlFlow.getInstructions();
        for (i = 0; i < instructions.length; ++i) {
            ProgressManager.checkCanceled();
            if (!instructions[i].process(processor2)) break;
        }
        return i;
    }

    public static void processLoopInstructions(@NotNull PhpControlFlow controlFlow, final @NotNull Processor<PhpLoopHostInstructionImpl> processor2) {
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(28);
        }
        PhpControlFlowUtil.processFlow(controlFlow, new PhpInstructionProcessor(){

            public boolean processHostInstruction(PhpHostInstruction instruction) {
                if (instruction instanceof PhpLoopHostInstructionImpl) {
                    return processor2.process((Object)((PhpLoopHostInstructionImpl)instruction));
                }
                return true;
            }
        });
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstruction(@Nullable PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (anchor == null) {
            return null;
        }
        return PhpControlFlowUtil.getAccessInstructionInScopeHolder(PhpPsiUtil.getScopeHolder((PsiElement)anchor), anchor, instructionClass);
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstructionInScopeHolder(@Nullable PhpScopeHolder scopeHolder, @NotNull PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(30);
        }
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(31);
        }
        if (scopeHolder == null) {
            return null;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        return (T)((PhpAccessInstruction)flow.getInstruction((PsiElement)anchor, instructionClass));
    }

    @Nullable
    public static PhpCallInstruction getCallInstruction(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(32);
        }
        return PhpControlFlowUtil.getInstruction((PsiElement)functionReference, PhpCallInstruction.class);
    }

    @Nullable
    public static <T extends PhpInstruction> T getInstruction(@NotNull PsiElement anchor, Class<T> aClass) {
        PhpScopeHolder scopeHolder;
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(33);
        }
        return (T)((scopeHolder = PhpPsiUtil.getScopeHolder(anchor)) != null ? scopeHolder.getControlFlow().getInstruction(anchor, aClass) : null);
    }

    @Nullable
    public static PhpFirstClassCallableInstructionImpl getFirstClassCallableInstruction(@NotNull PhpCallableFunction reference) {
        if (reference == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(34);
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)reference);
        return (PhpFirstClassCallableInstructionImpl)scopeHolder.getControlFlow().getInstruction((PsiElement)reference, PhpFirstClassCallableInstructionImpl.class);
    }

    @Nullable
    public static PhpStatementInstruction getStatementInstruction(@NotNull PhpControlFlow controlFlow, @NotNull Statement statement) {
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(35);
        }
        if (statement == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(36);
        }
        return (PhpStatementInstruction)controlFlow.getInstruction((PsiElement)statement, PhpStatementInstruction.class);
    }

    @Nullable
    public static PhpStatementInstruction getStatementInstruction(@NotNull Statement statement) {
        PhpScopeHolder scopeHolder;
        if (statement == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(37);
        }
        return (scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)statement)) != null ? (PhpStatementInstruction)scopeHolder.getControlFlow().getInstruction((PsiElement)statement, PhpStatementInstruction.class) : null;
    }

    public static void processPreviousVariableAccesses(@NotNull PhpAccessVariableInstruction point, boolean processSelf, @NotNull PhpInstructionProcessor processor2) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(38);
        }
        if (processor2 == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(39);
        }
        PhpControlFlowUtil.processPredecessors((PhpInstruction)point, processSelf, new MyVariableInstructionProcessor(point.getVariableName(), processor2));
    }

    public static PhpAccessVariableInstruction @NotNull [] getFollowingVariableAccessInstructions(@NotNull PhpInstruction point, final @NotNull CharSequence variableName, final boolean successorsOnly) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(40);
        }
        if (variableName == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(41);
        }
        final ArrayList followingAccesses = new ArrayList();
        PhpControlFlowUtil.processSuccessors(point, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    followingAccesses.add(instruction);
                    return !successorsOnly;
                }
                return true;
            }
        });
        if (followingAccesses.isEmpty()) {
            if (PhpAccessVariableInstruction.EMPTY_ARRAY == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(42);
            }
            return PhpAccessVariableInstruction.EMPTY_ARRAY;
        }
        PhpAccessVariableInstruction[] phpAccessVariableInstructionArray = followingAccesses.toArray(PhpAccessVariableInstruction.EMPTY_ARRAY);
        if (phpAccessVariableInstructionArray == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(43);
        }
        return phpAccessVariableInstructionArray;
    }

    public static boolean isPredecessor(@NotNull PhpInstruction instruction, final @NotNull PhpInstruction candidate) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(44);
        }
        if (candidate == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(45);
        }
        final Ref isReachedRef = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction curInstruction) {
                if (curInstruction == candidate) {
                    isReachedRef.set((Object)true);
                }
                return (Boolean)isReachedRef.get() == false;
            }
        });
        return (Boolean)isReachedRef.get();
    }

    public static boolean isReferencedInUseList(@NotNull Function function, @NotNull Variable accessedVariable) {
        if (function == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(46);
        }
        if (accessedVariable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(47);
        }
        if (!function.isClosure()) {
            return false;
        }
        PhpUseList useList = (PhpUseList)PsiTreeUtil.findChildOfType((PsiElement)function, PhpUseList.class);
        if (useList == null) {
            return false;
        }
        Object[] variables = (Variable[])PsiTreeUtil.getChildrenOfType((PsiElement)useList, Variable.class);
        if (ArrayUtil.isEmpty((Object[])variables)) {
            return false;
        }
        if (!accessedVariable.canReadName()) {
            return false;
        }
        String accessedVariableName = accessedVariable.getName();
        for (Object variable : variables) {
            if (!PhpLangUtil.equalsVariableNames(variable.getName(), accessedVariableName) || !PhpWorkaroundUtil.isReadReference((PsiElement)variable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPassByRefParameter(@NotNull Variable accessedVariable) {
        PsiElement resolvedElement;
        if (accessedVariable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(48);
        }
        return (resolvedElement = (PsiElement)accessedVariable.resolveLocal().stream().findFirst().orElse(null)) instanceof Parameter && ((Parameter)resolvedElement).isPassByRef();
    }

    public static Boolean hasPredecessorWithRefAccess(final @NotNull PhpAccessVariableInstruction accessInstruction, final @NotNull Variable variable) {
        if (accessInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(49);
        }
        if (variable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(50);
        }
        final Ref isReferenced = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                Boolean result = PhpControlFlowCacheUtil.tryFetchPreviouslyComputedResultFromCache((PhpInstruction)accessInstruction, variable.getName(), HAS_REF_ACCESS);
                if (result != null) {
                    isReferenced.set((Object)result);
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processAccessVariableInstruction(@NotNull PhpAccessVariableInstruction instruction) {
                if (instruction == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (!super.processAccessVariableInstruction(instruction)) {
                    return false;
                }
                if (instruction != accessInstruction && PhpLangUtil.equalsVariableNames(variable.getName(), instruction.getVariableName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    isReferenced.set((Object)((Boolean)isReferenced.get() != false || access.isWriteRef() || access.isReadRef() ? 1 : 0));
                }
                return (Boolean)isReferenced.get() == false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$7", "processAccessVariableInstruction"));
            }
        });
        Boolean result = (Boolean)isReferenced.get();
        PhpControlFlowCacheUtil.updateCache((PhpInstruction)accessInstruction, variable.getName(), result, HAS_REF_ACCESS);
        return result;
    }

    public static boolean isReferenced(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpAccessVariableInstruction accessInstruction) {
        PhpPsiElement anchor;
        if (scopeHolder == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(51);
        }
        if (accessInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(52);
        }
        if ((anchor = accessInstruction.getAnchor()) instanceof Variable) {
            Function function;
            Variable accessedVariable = (Variable)anchor;
            if (!accessedVariable.canReadName()) {
                return false;
            }
            if (scopeHolder instanceof Function && (PhpControlFlowUtil.isReferencedInUseList(function = (Function)scopeHolder, accessedVariable) || PhpControlFlowUtil.isPassByRefParameter(accessedVariable))) {
                return true;
            }
            return PhpControlFlowUtil.hasPredecessorWithRefAccess(accessInstruction, accessedVariable);
        }
        return false;
    }

    public static void processFile(@NotNull PhpFile file, @NotNull PhpInstructionProcessor collector) {
        block4: {
            if (file == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(53);
            }
            if (collector == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(54);
            }
            try {
                StreamEx.of((Collection)file.getTopLevelDefs().values()).select(PhpNamespace.class).map(PhpScopeHolder::getControlFlow).append((Object)file.getControlFlow()).forEach(cf -> PhpControlFlowUtil.processFlow(cf, collector));
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) break block4;
                LOG.warn("Exception while building control flow for " + file.getName(), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalInstruction";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendPredecessorsStrategy";
                break;
            }
            case 25: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionClass";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedVariable";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetPotentialNonEmptyVariableNames";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFollowingVariableAccessInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetPotentialNonEmptyVariableNames";
                break;
            }
            case 1: 
            case 42: 
            case 43: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSuccessors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendSuccessors";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreBackEdges";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreInitialBackEdges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendPredecessors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setAmbiguousPredecessors";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processFlow";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processLoopInstructions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstruction";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstructionInScopeHolder";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCallInstruction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getInstruction";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFirstClassCallableInstruction";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStatementInstruction";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processPreviousVariableAccesses";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableAccessInstructions";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isPredecessor";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedInUseList";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRefParameter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasPredecessorWithRefAccess";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 42, 43 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface AppendPredecessorsStrategy {
        public void appendPredecessors(@NotNull PhpInstruction var1, @NotNull Collection<PhpInstruction> var2, int var3, List<PhpInstruction> var4);
    }

    private static class MyVariableInstructionProcessor
    extends PhpInstructionProcessor {
        private final PhpInstructionProcessor myProcessor;
        private final CharSequence myVariableName;

        MyVariableInstructionProcessor(@NotNull CharSequence variableName, PhpInstructionProcessor processor2) {
            if (variableName == null) {
                MyVariableInstructionProcessor.$$$reportNull$$$0(0);
            }
            this.myVariableName = variableName;
            this.myProcessor = processor2;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName())) {
                return this.myProcessor.processAccessVariableInstruction(instruction);
            }
            return true;
        }

        public boolean processInstruction(PhpInstruction instruction) {
            boolean res = instruction.process(this.myProcessor);
            if (this.myProcessor.shouldHaltTraversal()) {
                this.haltTraversal();
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$MyVariableInstructionProcessor", "<init>"));
        }
    }

    private static class MyIgnoreInitialBackEdgesAppendPredecessorsStrategy
    implements AppendPredecessorsStrategy {
        private MyIgnoreInitialBackEdgesAppendPredecessorsStrategy() {
        }

        @Override
        public void appendPredecessors(@NotNull PhpInstruction instruction, @NotNull Collection<PhpInstruction> pool, int initialNumber, List<PhpInstruction> predecessors) {
            if (instruction == null) {
                MyIgnoreInitialBackEdgesAppendPredecessorsStrategy.$$$reportNull$$$0(0);
            }
            if (pool == null) {
                MyIgnoreInitialBackEdgesAppendPredecessorsStrategy.$$$reportNull$$$0(1);
            }
            PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
            int size = predecessors.size();
            for (int i = 0; i < size; ++i) {
                PhpInstruction predecessor = predecessors.get(i);
                if (initialNumber <= predecessor.num() || this.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
                pool.add(predecessor);
            }
        }

        protected boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skippedLoopInstruction, PhpInstruction predecessor) {
            return PhpControlFlowUtil.alwaysNonEmpty(skippedLoopInstruction, predecessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "instruction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pool";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$MyIgnoreInitialBackEdgesAppendPredecessorsStrategy";
            objectArray[2] = "appendPredecessors";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpRecursiveInstructionProcessor
    extends PhpInstructionProcessor {
        private static final int DEPTH_LIMIT = 100;
        private int myDepth = 0;

        public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
            this.processFlow((PhpScopeHolder)instruction.getFunctionDeclaration());
            return super.processFunctionDeclarationInstruction(instruction);
        }

        public boolean processClassDeclarationInstruction(PhpClassDeclarationInstruction instruction) {
            for (Method method : instruction.getClassDeclaration().getOwnMethods()) {
                this.processFlow((PhpScopeHolder)method);
            }
            return super.processClassDeclarationInstruction(instruction);
        }

        private void processFlow(@NotNull PhpScopeHolder scopeHolder) {
            if (scopeHolder == null) {
                PhpRecursiveInstructionProcessor.$$$reportNull$$$0(0);
            }
            if (this.myDepth++ <= this.getLimit()) {
                PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), this);
            }
            --this.myDepth;
        }

        protected int getLimit() {
            return 100;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeHolder", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$PhpRecursiveInstructionProcessor", "processFlow"));
        }
    }

    @ApiStatus.Internal
    public static class PhpClosureVisitingInstructionProcessor
    extends PhpInstructionProcessor {
        public boolean processInstruction(PhpInstruction instruction) {
            if (!super.processInstruction(instruction)) {
                return false;
            }
            for (Function function : ((PhpInstructionImpl)instruction).getClosuresAfter()) {
                for (PhpInstruction closureInstruction : function.getControlFlow().getInstructions()) {
                    if (closureInstruction.process((PhpInstructionProcessor)this)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

