/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(2);
        }
        HashSet<Statement> visited = new HashSet<Statement>();
        for (PsiElement psiElement : elements) {
            Function closure;
            ProgressManager.checkCanceled();
            PsiElement parent = psiElement.getParent();
            Statement statement = null;
            if (parent instanceof FunctionReference) {
                FunctionReference functionReference = (FunctionReference)parent;
                if (((PhpReference)parent).getNameNode() == psiElement && PhpRecursiveCallLineMarkerProvider.isRecursiveMethodCall(functionReference)) {
                    statement = (Statement)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
                }
            }
            if (parent instanceof Variable && parent.getParent() instanceof FunctionReference && ((PhpReference)parent).getNameNode() == psiElement && PhpRecursiveCallLineMarkerProvider.isRecursiveClosure(closure = (Function)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF), (Variable)parent)) {
                statement = (Statement)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
            }
            if (statement == null || visited.contains(statement)) continue;
            visited.add(statement);
            result.add(new PhpRecursiveMethodCallMarkerInfo(psiElement));
        }
    }

    public static boolean isRecursiveClosure(Function closure, @NotNull Variable parent) {
        if (parent == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (closure == null || !closure.isClosure()) {
            return false;
        }
        AssignmentExpression expression = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)closure, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (expression == null) {
            return false;
        }
        Variable variable = (Variable)ObjectUtils.tryCast((Object)expression.getVariable(), Variable.class);
        if (variable == null || !PhpLangUtil.equalsVariableNames(parent.getName(), variable.getName())) {
            return false;
        }
        Collection<Variable> variablesFromUseList = PhpPsiUtil.getUsedVariables(closure);
        return variablesFromUseList.stream().filter(v -> PhpLangUtil.equalsVariableNames(parent.getName(), v.getName())).anyMatch(PhpWorkaroundUtil::isReadReference);
    }

    public static boolean isRecursiveMethodCall(@NotNull FunctionReference functionReference) {
        String name;
        if (functionReference == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(name = functionReference.getName()))) {
            return false;
        }
        if (functionReference instanceof MethodReference && !PhpRecursiveCallLineMarkerProvider.isRecursionPossible((MethodReference)functionReference)) {
            return false;
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        if (function == null || !PhpLangUtil.equalsFunctionNames(name, function.getName())) {
            return false;
        }
        return functionReference.resolveLocal().contains(function);
    }

    private static boolean isRecursionPossible(@NotNull MethodReference methodReference) {
        PhpExpression expression;
        if (methodReference == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((expression = methodReference.getClassReference()) instanceof Variable) {
            if ("this".equals(expression.getName())) {
                return true;
            }
        } else if (expression instanceof ClassReference) {
            PhpClass phpClass;
            String name = expression.getName();
            if ("self".equals(name) || "static".equals(name)) {
                return true;
            }
            if (methodReference.getReferenceType() == PhpModifier.State.STATIC && (phpClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) != null && PhpLangUtil.equalsClassNames(name, phpClass.getName())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("recursive.call", new Object[0]);
        if (string == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.RecursiveMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveClosure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveMethodCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRecursionPossible";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static final class PhpRecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private PhpRecursiveMethodCallMarkerInfo(@NotNull PsiElement functionReference) {
            if (functionReference == null) {
                PhpRecursiveMethodCallMarkerInfo.$$$reportNull$$$0(0);
            }
            super(functionReference, functionReference.getTextRange(), AllIcons.Gutter.RecursiveMethod, reference -> PhpBundle.message("recursive.call", new Object[0]), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider$PhpRecursiveMethodCallMarkerInfo", "<init>"));
        }
    }
}

