/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.builtInWebServer.PhpCgiService;
import com.jetbrains.php.lang.PhpFileType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.io.fastCgi.FastCgiRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpWebServerFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "<init>", "()V", "pageFileExtensions", "", "", "getPageFileExtensions", "()Ljava/util/List;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.php.jsDebugger"})
final class PhpWebServerFileHandler
extends WebServerFileHandler {
    @NotNull
    private final List<String> pageFileExtensions;

    public PhpWebServerFileHandler() {
        Object[] objectArray = new String[]{"php", "php5", "php4", "phtml", "hphp"};
        this.pageFileExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        if (!Intrinsics.areEqual((Object)pathInfo.getFileType(), (Object)PhpFileType.INSTANCE)) {
            return false;
        }
        PhpCgiService cgiService = PhpCgiService.Companion.getInstance$intellij_php_jsDebugger(project);
        int n = cgiService.allocateRequestId(channel, pathInfo, request, extraHeaders);
        ByteBufAllocator byteBufAllocator = channel.alloc();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"alloc(...)");
        FastCgiRequest fastCgiRequest = new FastCgiRequest(n, byteBufAllocator);
        fastCgiRequest.writeHeaders(request, channel);
        fastCgiRequest.writeFileHeaders(pathInfo, (CharSequence)this.getRequestPath(canonicalPath, projectNameIfNotCustomHost));
        ByteBuf byteBuf = request.content();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
        cgiService.send(fastCgiRequest, byteBuf);
        return true;
    }
}

