/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste.importReferences;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.ui.SimpleColoredComponent;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.actions.copyPaste.importReferences.PhpReferenceInfo;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class PhpReferenceInfosRenderer
extends SimpleColoredComponent
implements ListCellRenderer<PhpReferenceInfo> {
    private final Font FONT;

    PhpReferenceInfosRenderer() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.FONT = scheme.getFont(EditorFontType.PLAIN);
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends PhpReferenceInfo> list, PhpReferenceInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        this.clear();
        this.setIcon(PhpReferenceInfosRenderer.getIcon(value));
        this.append(PhpLangUtil.toPresentableFQN(value.getFqn()));
        if (value.getAliasName() != null) {
            this.append(" (" + value.getAliasName() + ")");
        }
        this.setFont(this.FONT);
        this.handleSelection(list, isSelected);
        return this;
    }

    protected void handleSelection(JList<? extends PhpReferenceInfo> list, boolean isSelected) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
    }

    @NotNull
    private static Icon getIcon(@NotNull PhpReferenceInfo value) {
        if (value == null) {
            PhpReferenceInfosRenderer.$$$reportNull$$$0(0);
        }
        Icon icon = switch (value.getKeyword()) {
            case PhpGroupUseElement.PhpUseKeyword.CONSTANT -> PhpIcons.CONSTANT;
            case PhpGroupUseElement.PhpUseKeyword.FUNCTION -> PhpIcons.FUNCTION;
            default -> PhpIcons.CLASS;
        };
        if (icon == null) {
            PhpReferenceInfosRenderer.$$$reportNull$$$0(1);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferenceInfosRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferenceInfosRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

