/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.copyPaste.PhpCheckRegExpNotifierCollector;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.awt.Point;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.intellij.lang.regexp.RegExpFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCheckRegExpNotifier {
    public static final String KEY = "check.regexp.promotion";

    @Nullable
    private static GotItTooltip getTooltip(PsiFile file, Editor editor, int caretOffset) {
        if (!file.isValid()) {
            return null;
        }
        if (!PhpCheckRegExpNotifier.canShowTooltip(file, caretOffset)) {
            return null;
        }
        IntentionAction action = (IntentionAction)ContainerUtil.find((Object[])IntentionManager.getInstance().getIntentionActions(), a -> a.getFamilyName().equals("Check RegExp"));
        if (action != null && action.isAvailable(file.getProject(), editor, file)) {
            Disposable parentDisposable = Disposer.newDisposable();
            return new GotItTooltip("check.regexp.promotion.tooltip", PhpBundle.message("php.check.validity.reg.exp", new Object[0]), parentDisposable).withLink(PhpBundle.message("php.run.check.reg.exp", KeymapUtil.getFirstKeyboardShortcutText((String)"ShowIntentionActions")), () -> {
                PhpCheckRegExpNotifierCollector.logRunCheckRegexpIntention();
                action.invoke(file.getProject(), editor, file);
            });
        }
        return null;
    }

    public static boolean canShowTooltip(@NotNull PsiFile file, int caretOffset) {
        if (file == null) {
            PhpCheckRegExpNotifier.$$$reportNull$$$0(0);
        }
        return PhpCheckRegExpNotifier.isFirstNotificationRun() && PhpCheckRegExpNotifier.isRegExpInjection(file, caretOffset);
    }

    public static boolean isFirstNotificationRun() {
        return !PropertiesComponent.getInstance().getBoolean(KEY);
    }

    private static boolean isRegExpInjection(@NotNull PsiFile file, int caretOffset) {
        PsiLanguageInjectionHost host;
        if (file == null) {
            PhpCheckRegExpNotifier.$$$reportNull$$$0(1);
        }
        if ((host = (PsiLanguageInjectionHost)PhpPsiUtil.getParentByCondition(file.findElementAt(caretOffset), (Condition<? super PsiElement>)((Condition)e -> e instanceof PsiLanguageInjectionHost), (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
            return false;
        }
        Pair injection = (Pair)ContainerUtil.getOnlyItem((Collection)InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host));
        return injection != null && injection.first instanceof RegExpFile;
    }

    public static void tryToPromoteCheckRegExpIntention(@NotNull PsiFile file, int caretOffset) {
        Editor editor;
        if (file == null) {
            PhpCheckRegExpNotifier.$$$reportNull$$$0(2);
        }
        if ((editor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor()) == null || LightEdit.owns((Project)file.getProject())) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && PhpCheckRegExpNotifier.canShowTooltip(file, caretOffset)) {
            PropertiesComponent.getInstance().setValue(KEY, true);
        } else {
            ReadAction.nonBlocking(() -> PhpCheckRegExpNotifier.getTooltip(file, editor, caretOffset)).inSmartMode(file.getProject()).finishOnUiThread(ModalityState.nonModal(), tooltip -> {
                if (tooltip != null) {
                    PropertiesComponent.getInstance().setValue(KEY, true);
                    PhpCheckRegExpNotifier.notify(tooltip, editor, caretOffset);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private static void notify(@NotNull GotItTooltip tooltip, @NotNull Editor editor, int caretOffset) {
        if (tooltip == null) {
            PhpCheckRegExpNotifier.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpCheckRegExpNotifier.$$$reportNull$$$0(4);
        }
        tooltip.show(editor.getContentComponent(), (a, b) -> {
            PhpCheckRegExpNotifierCollector.logShowToolTip();
            Point point = editor.offsetToXY(caretOffset);
            int x = point.x;
            int y = point.y + 2 * UISettings.getInstance().getFontSize();
            return new Point(x, y);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/actions/copyPaste/PhpCheckRegExpNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowTooltip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegExpInjection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToPromoteCheckRegExpIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

