/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewClassMockDataProvider
implements PhpNewClassDataProvider {
    public static final String DIALOG_JSON_FILE = "PhpNewClassMockDataProvider.json";
    private String myClassName;
    private String myNamespaceName;
    private final String myFileName;
    private ClassCreationType myKindOfTemplate;
    private String myFullPathToDir;
    private PsiDirectory myExistingDirectory;
    @Nullable
    private final String mySuperFqn;
    @NotNull
    private final Collection<String> myInterfacesToImplement;

    public PhpNewClassMockDataProvider(@NotNull Project project, @Nullable String className, @NotNull String namespaceName, @NotNull ClassCreationType kindOfTemplate, @Nullable String fileName, @NotNull PhpDirectoryProvider provider, @NotNull PsiDirectory contextDir) {
        if (project == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(0);
        }
        if (namespaceName == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(1);
        }
        if (kindOfTemplate == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(3);
        }
        if (contextDir == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(4);
        }
        this(project, className, namespaceName, kindOfTemplate, fileName, provider, contextDir, null, Collections.emptyList());
    }

    public PhpNewClassMockDataProvider(@NotNull Project project, @Nullable String className, @NotNull String namespaceName, @NotNull ClassCreationType kindOfTemplate, @Nullable String fileName, @NotNull PhpDirectoryProvider provider, @NotNull PsiDirectory contextDir, @Nullable String superFqn, @NotNull Collection<String> interfacesToImplement) {
        if (project == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(5);
        }
        if (namespaceName == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(6);
        }
        if (kindOfTemplate == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(8);
        }
        if (contextDir == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(9);
        }
        if (interfacesToImplement == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(10);
        }
        this.myFullPathToDir = "";
        this.myClassName = className;
        this.myNamespaceName = namespaceName;
        this.myKindOfTemplate = kindOfTemplate;
        this.myFileName = fileName;
        this.myExistingDirectory = contextDir;
        List<String> suggestions = provider.suggestDirectories(project, contextDir.getVirtualFile(), namespaceName);
        String suggestedPath = PathUtil.toSystemIndependentName((String)suggestions.get(0));
        PsiDirectory parent = PhpNewClassMockDataProvider.findExistingParent(contextDir, suggestedPath);
        if (parent != null) {
            String basePath = parent.getVirtualFile().getPath();
            this.myFullPathToDir = FileUtil.toCanonicalPath((String)FileUtil.getRelativePath((String)basePath, (String)suggestedPath, (char)'/'));
            this.myExistingDirectory = parent;
        }
        this.mySuperFqn = superFqn != null && PhpNewClassDialog.isOverridableClass(project, superFqn) ? superFqn : null;
        this.myInterfacesToImplement = ContainerUtil.filter(interfacesToImplement, fqn -> PhpNewClassDialog.isImplementableInterface(project, fqn));
    }

    @Nullable
    private static PsiDirectory findExistingParent(@Nullable PsiDirectory directory, @NotNull String path) {
        if (path == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(11);
        }
        while (directory != null && !FileUtil.isAncestor((String)directory.getVirtualFile().getPath(), (String)path, (boolean)false)) {
            directory = directory.getParent();
        }
        return directory;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public String getNamespaceName() {
        return this.myNamespaceName;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public String getSuperFqn() {
        return PhpNewClassDialog.canOverrideSuperClass(this.myKindOfTemplate) ? this.mySuperFqn : null;
    }

    @Override
    @NotNull
    public Collection<String> getInterfaceFqnsToImplement() {
        Collection<Object> collection = PhpNewClassDialog.canImplementInterface(this.myKindOfTemplate) ? this.myInterfacesToImplement : Collections.emptyList();
        if (collection == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    public boolean canInheritSuperClasses() {
        return PhpNewClassDialog.canOverrideSuperClass(this.myKindOfTemplate) || PhpNewClassDialog.canImplementInterface(this.myKindOfTemplate);
    }

    @Override
    public boolean shouldImplementAbstractMethods() {
        return PhpNewClassDialog.canOverrideSuperClass(this.myKindOfTemplate);
    }

    @Override
    public void setData(String className, ClassCreationType kindOfTemplate, String fileName, String namespaceName) {
        this.myClassName = className;
        this.myNamespaceName = namespaceName;
        this.myKindOfTemplate = kindOfTemplate;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string = this.myKindOfTemplate.getTemplateName();
        if (string == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFilePath() {
        String fileName = this.getFileName() + ".php";
        if (StringUtil.isEmpty((String)this.myFullPathToDir)) {
            String string = fileName;
            if (string == null) {
                PhpNewClassMockDataProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = PathUtil.toSystemDependentName((String)this.myFullPathToDir) + File.separator + fileName;
        if (string == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.myExistingDirectory;
        if (psiDirectory == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(17);
        }
        return psiDirectory;
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(18);
        }
        Properties properties = FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties();
        if (properties == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(19);
        }
        return properties;
    }

    @NotNull
    public static PhpNewClassDataProvider getMockProvider(@NotNull Project project, @NotNull ClassCreationType kindOfTemplate, String namespacePrefill, String className, String filename, PsiDirectory contextDir, PhpDirectoryProvider provider) {
        PsiFile dialogPropertiesFile;
        if (project == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(20);
        }
        if (kindOfTemplate == null) {
            PhpNewClassMockDataProvider.$$$reportNull$$$0(21);
        }
        if ((dialogPropertiesFile = contextDir.findFile(DIALOG_JSON_FILE)) instanceof JsonFile) {
            Properties properties = new Properties();
            JsonObject jsonObject = (JsonObject)ObjectUtils.tryCast((Object)dialogPropertiesFile.getFirstChild(), JsonObject.class);
            if (jsonObject != null) {
                jsonObject.getPropertyList().forEach(e -> properties.setProperty(e.getName(), Objects.requireNonNull(JsonPsiUtil.stripQuotes((String)Objects.requireNonNull(e.getValue()).getText()))));
                className = PhpNewClassMockDataProvider.getProperty(className, properties, "NAME");
                namespacePrefill = PhpNewClassMockDataProvider.getProperty(namespacePrefill, properties, "NAMESPACE").replace("\\\\", "\\");
                filename = PhpNewClassMockDataProvider.getProperty(filename, properties, "FILENAME");
                ClassCreationType customKindOfTemplate = ClassCreationType.fromString(properties.getProperty("KIND"));
                kindOfTemplate = customKindOfTemplate != null ? customKindOfTemplate : kindOfTemplate;
            }
        }
        return new PhpNewClassMockDataProvider(project, className, namespacePrefill, kindOfTemplate, filename, provider, contextDir);
    }

    private static String getProperty(String className, Properties properties, String name) {
        String customName = properties.getProperty(name);
        className = customName != null ? customName : className;
        return className;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 2: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindOfTemplate";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfacesToImplement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewClassMockDataProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewClassMockDataProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceFqnsToImplement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingParent";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMockProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

