/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

@Service(value={Service.Level.PROJECT})
public final class PhpCaches
implements Disposable {
    public static final int TYPE_CACHE_SIZE = 7000;
    private final LowMemoryWatcher myLowMemoryWatcher;
    public volatile Map<String, PhpType> TYPE_COMPLETION_CACHE = new ConcurrentHashMap<String, PhpType>();
    public volatile Map<String, Collection<? extends PhpNamedElement>> SIGNATURES_CACHE = new ConcurrentHashMap<String, Collection<? extends PhpNamedElement>>();
    public volatile Map<String, Collection<PhpClass>> subclassCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> directSubclassesCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> classCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> interfaceCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> traitCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<Variable>> globalVariablesCache = new ConcurrentHashMap<String, Collection<Variable>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesClassCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesInterfaceCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesTraitCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> allAliasesCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<Constant>> caseSensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
    public volatile Map<String, Collection<Constant>> caseInsensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
    public volatile Map<String, Collection<Function>> functionsCache = new ConcurrentHashMap<String, Collection<Function>>();
    public volatile Map<String, Collection<String>> SUBCLASSES_CACHE = new ConcurrentHashMap<String, Collection<String>>();
    public volatile Map<PsiElement, PhpType> TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
    public volatile Map<PsiElement, PhpType> TYPE_WITHOUT_BACKEDGES_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
    public volatile Map<String, Collection<PhpShapeEntriesIndex.PhpShapeEntry>> shapesTypeCache = new ConcurrentHashMap<String, Collection<PhpShapeEntriesIndex.PhpShapeEntry>>();

    public PhpCaches(Project project) {
        this.myLowMemoryWatcher = LowMemoryWatcher.register(() -> this.clearCaches(true));
        PsiModificationTracker.Listener modificationHandler = () -> this.clearCaches(false);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)modificationHandler);
    }

    public void clearCaches(boolean onLowMem) {
        if (!this.TYPE_COMPLETION_CACHE.isEmpty()) {
            this.TYPE_COMPLETION_CACHE = new ConcurrentHashMap<String, PhpType>();
        }
        if (!this.SIGNATURES_CACHE.isEmpty()) {
            this.SIGNATURES_CACHE = new ConcurrentHashMap<String, Collection<? extends PhpNamedElement>>();
        }
        if (!this.classCache.isEmpty()) {
            this.classCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (!this.interfaceCache.isEmpty()) {
            this.interfaceCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (!this.traitCache.isEmpty()) {
            this.traitCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (!this.aliasesClassCache.isEmpty()) {
            this.aliasesClassCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (!this.aliasesInterfaceCache.isEmpty()) {
            this.aliasesInterfaceCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (!this.aliasesTraitCache.isEmpty()) {
            this.aliasesTraitCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (!this.allAliasesCache.isEmpty()) {
            this.allAliasesCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (!this.caseSensitiveConstantsCache.isEmpty()) {
            this.caseSensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
        }
        if (!this.caseInsensitiveConstantsCache.isEmpty()) {
            this.caseInsensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
        }
        if (!this.functionsCache.isEmpty()) {
            this.functionsCache = new ConcurrentHashMap<String, Collection<Function>>();
        }
        if (!this.SUBCLASSES_CACHE.isEmpty()) {
            this.SUBCLASSES_CACHE = new ConcurrentHashMap<String, Collection<String>>();
        }
        if (!this.shapesTypeCache.isEmpty()) {
            this.shapesTypeCache = new ConcurrentHashMap<String, Collection<PhpShapeEntriesIndex.PhpShapeEntry>>();
        }
        if (!this.globalVariablesCache.isEmpty()) {
            this.globalVariablesCache = new ConcurrentHashMap<String, Collection<Variable>>();
        }
        if (!this.subclassCache.isEmpty()) {
            this.subclassCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (!this.directSubclassesCache.isEmpty()) {
            this.directSubclassesCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        Map<PsiElement, PhpType> type_cache = this.TYPE_CACHE;
        if (!this.TYPE_CACHE.isEmpty()) {
            this.TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
            type_cache.clear();
        }
        Map<PsiElement, PhpType> type_cache_without_backedged = this.TYPE_WITHOUT_BACKEDGES_CACHE;
        if (!this.TYPE_WITHOUT_BACKEDGES_CACHE.isEmpty()) {
            this.TYPE_WITHOUT_BACKEDGES_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
            type_cache_without_backedged.clear();
        }
    }

    public void dispose() {
        this.myLowMemoryWatcher.stop();
        this.clearCaches(true);
    }

    public static PhpCaches getInstance(Project project) {
        return (PhpCaches)project.getService(PhpCaches.class);
    }
}

