/*
 * Decompiled with CFR 0.152.
 */
package com.pestphp.pest.runner;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.DocumentUtil;
import com.jetbrains.php.util.pathmapper.PhpLocalPathMapper;
import com.pestphp.pest.configuration.PestLocationProvider;
import com.pestphp.pest.runner.PestTestStackTraceParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"parse", "Lcom/pestphp/pest/runner/PestTestStackTraceParser;", "url", "", "stacktrace", "errorMessage", "locator", "Lcom/pestphp/pest/configuration/PestLocationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "getLineText", "path", "line", "", "intellij.pest"})
@SourceDebugExtension(value={"SMAP\nPestTestStackTraceParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestTestStackTraceParser.kt\ncom/pestphp/pest/runner/PestTestStackTraceParserKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,52:1\n106#2:53\n78#2,22:54\n*S KotlinDebug\n*F\n+ 1 PestTestStackTraceParser.kt\ncom/pestphp/pest/runner/PestTestStackTraceParserKt\n*L\n23#1:53\n23#1:54,22\n*E\n"})
public final class PestTestStackTraceParserKt {
    @NotNull
    public static final PestTestStackTraceParser parse(@NotNull String url, @Nullable String stacktrace, @Nullable String errorMessage, @NotNull PestLocationProvider locator, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (stacktrace == null) {
            return new PestTestStackTraceParser(errorMessage);
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)stacktrace, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (lines.isEmpty()) {
            return new PestTestStackTraceParser(errorMessage);
        }
        CharSequence charSequence = errorMessage;
        String realErrorMessage = charSequence == null || charSequence.length() == 0 ? (String)lines.get(0) : errorMessage;
        String path = StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)url, (CharSequence)"pest_qn://"), (String)"::", null, (int)2, null);
        String $this$trim$iv = (String)CollectionsKt.last((List)lines);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String lastLine = StringsKt.substringAfter$default((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"at ", null, (int)2, null);
        if (Intrinsics.areEqual((Object)path, (Object)url) || !StringsKt.startsWith$default((String)lastLine, (String)path, (boolean)false, (int)2, null)) {
            return new PestTestStackTraceParser(realErrorMessage);
        }
        String string = lastLine.substring(path.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int failedLine = StringUtil.parseInt((String)string, (int)-1);
        String failedLineText = failedLine > 0 ? PestTestStackTraceParserKt.getLineText(path, failedLine, project, locator) : null;
        return new PestTestStackTraceParser(failedLine, failedLineText, realErrorMessage, null);
    }

    private static final String getLineText(String path, int line, Project project, PestLocationProvider locator) {
        String fileUrl = locator.calculateFileUrl(path);
        VirtualFile virtualFile = locator.getPathMapper().getLocalFile(fileUrl);
        if (virtualFile == null && (virtualFile = new PhpLocalPathMapper(project).getLocalFile(fileUrl)) == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (line > document2.getLineCount()) {
            return null;
        }
        TextRange textRange = DocumentUtil.getLineTextRange((Document)document2, (int)(line - 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLineTextRange(...)");
        TextRange range = textRange;
        return document2.getText(range);
    }
}

