/*
 * Decompiled with CFR 0.152.
 */
package com.pestphp.pest.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.pestphp.pest.PestBundle;
import com.pestphp.pest.PestNamingUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J(\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J0\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/pestphp/pest/configuration/PestRunConfigurationHandler;", "Lcom/jetbrains/php/testFramework/run/PhpTestRunConfigurationHandler;", "<init>", "()V", "rootPath", "", "getRootPath", "()Ljava/lang/String;", "setRootPath", "(Ljava/lang/String;)V", "getConfigFileOption", "prepareCommand", "", "project", "Lcom/intellij/openapi/project/Project;", "commandSettings", "Lcom/jetbrains/php/config/commandLine/PhpCommandSettings;", "exe", "version", "runType", "phpCommandSettings", "type", "workingDirectory", "runDirectory", "directory", "runFile", "file", "runMethod", "methodName", "Companion", "intellij.pest"})
public final class PestRunConfigurationHandler
implements PhpTestRunConfigurationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String rootPath;
    @JvmField
    @NotNull
    public static final PestRunConfigurationHandler instance = new PestRunConfigurationHandler();

    @Nullable
    public final String getRootPath() {
        return this.rootPath;
    }

    public final void setRootPath(@Nullable String string) {
        this.rootPath = string;
    }

    @NotNull
    public String getConfigFileOption() {
        return "--configuration";
    }

    public void prepareCommand(@NotNull Project project, @NotNull PhpCommandSettings commandSettings, @NotNull String exe, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commandSettings, (String)"commandSettings");
        Intrinsics.checkNotNullParameter((Object)exe, (String)"exe");
        commandSettings.setScript(exe, false);
        commandSettings.addArgument("--teamcity");
        commandSettings.addEnv("IDE_PEST_EXE", exe);
        CharSequence charSequence = version;
        if (!(charSequence == null || charSequence.length() == 0)) {
            commandSettings.addEnv("IDE_PEST_VERSION", version);
        }
    }

    public void runType(@NotNull Project project, @NotNull PhpCommandSettings phpCommandSettings, @NotNull String type, @NotNull String workingDirectory) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)phpCommandSettings, (String)"phpCommandSettings");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        throw new ExecutionException(PestBundle.message("CANNOT_RUN_PEST_WITH_TYPE_MESSAGE", new Object[0]));
    }

    public void runDirectory(@NotNull Project project, @NotNull PhpCommandSettings phpCommandSettings, @NotNull String directory, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)phpCommandSettings, (String)"phpCommandSettings");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (((CharSequence)directory).length() == 0) {
            return;
        }
        phpCommandSettings.addPathArgument(directory);
    }

    public void runFile(@NotNull Project project, @NotNull PhpCommandSettings phpCommandSettings, @NotNull String file, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)phpCommandSettings, (String)"phpCommandSettings");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (((CharSequence)file).length() == 0) {
            return;
        }
        phpCommandSettings.addPathArgument(file);
    }

    public void runMethod(@NotNull Project project, @NotNull PhpCommandSettings phpCommandSettings, @NotNull String file, @NotNull String methodName, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)phpCommandSettings, (String)"phpCommandSettings");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (((CharSequence)file).length() == 0) {
            return;
        }
        PhpPathMapper phpPathMapper = phpCommandSettings.getPathProcessor().createPathMapper(project);
        Intrinsics.checkNotNullExpressionValue((Object)phpPathMapper, (String)"createPathMapper(...)");
        PhpPathMapper pathMapper = phpPathMapper;
        String string = this.rootPath;
        if (string == null) {
            string = workingDirectory;
        }
        String rootPath = string;
        phpCommandSettings.addPathArgument(file);
        phpCommandSettings.addArgument("--filter");
        phpCommandSettings.addArgument("/" + PestNamingUtilKt.toPestTestRegex(methodName, rootPath, file, pathMapper) + "/");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pestphp/pest/configuration/PestRunConfigurationHandler$Companion;", "", "<init>", "()V", "instance", "Lcom/pestphp/pest/configuration/PestRunConfigurationHandler;", "intellij.pest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

