/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020%H\u0014J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.J\u0012\u00100\u001a\u00020.2\b\u00101\u001a\u0004\u0018\u00010'H\u0016J\u0012\u00102\u001a\u00020.2\b\u00103\u001a\u0004\u0018\u00010'H\u0016J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020'H\u0016J,\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020.2\u000e\u0010@\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050AR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u000f\u001a\u0004\b!\u0010\"R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "", "language", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "builder", "Lcom/intellij/lang/PsiBuilder;", "<init>", "(Lcom/intellij/lang/javascript/JSLanguageDialect;Lcom/intellij/lang/PsiBuilder;)V", "getLanguage$intellij_javascript_parser", "()Lcom/intellij/lang/javascript/JSLanguageDialect;", "expressionParser", "Lcom/intellij/lang/javascript/parsing/ExpressionParser;", "getExpressionParser", "()Lcom/intellij/lang/javascript/parsing/ExpressionParser;", "expressionParser$delegate", "Lkotlin/Lazy;", "statementParser", "Lcom/intellij/lang/javascript/parsing/StatementParser;", "getStatementParser", "()Lcom/intellij/lang/javascript/parsing/StatementParser;", "statementParser$delegate", "functionParser", "Lcom/intellij/lang/javascript/parsing/FunctionParser;", "getFunctionParser", "()Lcom/intellij/lang/javascript/parsing/FunctionParser;", "functionParser$delegate", "typeParser", "Lcom/intellij/lang/javascript/parsing/JSPsiTypeParser;", "getTypeParser", "()Lcom/intellij/lang/javascript/parsing/JSPsiTypeParser;", "typeParser$delegate", "xmlParser", "Lcom/intellij/lang/javascript/parsing/JSXmlParser;", "getXmlParser", "()Lcom/intellij/lang/javascript/parsing/JSXmlParser;", "xmlParser$delegate", "parseJS", "", "root", "Lcom/intellij/psi/tree/IElementType;", "doParseJS", "fillBuilderDataFromContext", "context", "Lcom/intellij/psi/PsiElement;", "fillBuilderData", "isAsyncContext", "", "isGeneratorContext", "isIdentifierToken", "tokenType", "isIdentifierName", "firstToken", "dialect", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "getDialect", "()Lcom/intellij/lang/javascript/DialectOptionHolder;", "buildTokenElement", "type", "parseModifiers", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "structure", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "dropIfEmpty", "isPossibleStateAfterModifiers", "Ljava/util/function/Predicate;", "intellij.javascript.parser"})
public class JavaScriptParser {
    @NotNull
    private final JSLanguageDialect language;
    @JvmField
    @NotNull
    public final PsiBuilder builder;
    @NotNull
    private final Lazy expressionParser$delegate;
    @NotNull
    private final Lazy statementParser$delegate;
    @NotNull
    private final Lazy functionParser$delegate;
    @NotNull
    private final Lazy typeParser$delegate;
    @NotNull
    private final Lazy xmlParser$delegate;

    public JavaScriptParser(@NotNull JSLanguageDialect language, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.language = language;
        this.builder = builder;
        this.expressionParser$delegate = LazyKt.lazy(() -> JavaScriptParser.expressionParser_delegate$lambda$0(this));
        this.statementParser$delegate = LazyKt.lazy(() -> JavaScriptParser.statementParser_delegate$lambda$1(this));
        this.functionParser$delegate = LazyKt.lazy(() -> JavaScriptParser.functionParser_delegate$lambda$2(this));
        this.typeParser$delegate = LazyKt.lazy(() -> JavaScriptParser.typeParser_delegate$lambda$3(this));
        this.xmlParser$delegate = LazyKt.lazy(() -> JavaScriptParser.xmlParser_delegate$lambda$4(this));
    }

    @NotNull
    public final JSLanguageDialect getLanguage$intellij_javascript_parser() {
        return this.language;
    }

    @NotNull
    public ExpressionParser<?> getExpressionParser() {
        Lazy lazy = this.expressionParser$delegate;
        return (ExpressionParser)lazy.getValue();
    }

    @NotNull
    public StatementParser<?> getStatementParser() {
        Lazy lazy = this.statementParser$delegate;
        return (StatementParser)lazy.getValue();
    }

    @NotNull
    public FunctionParser<?> getFunctionParser() {
        Lazy lazy = this.functionParser$delegate;
        return (FunctionParser)lazy.getValue();
    }

    @NotNull
    public JSPsiTypeParser<?> getTypeParser() {
        Lazy lazy = this.typeParser$delegate;
        return (JSPsiTypeParser)lazy.getValue();
    }

    @NotNull
    public JSXmlParser getXmlParser() {
        Lazy lazy = this.xmlParser$delegate;
        return (JSXmlParser)lazy.getValue();
    }

    public final void parseJS(@NotNull IElementType root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker rootMarker = marker;
        JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
        if (forceContext != null) {
            if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else {
                if (forceContext == JavaScriptParserBase.ForceContext.TypeAllowEmpty && this.builder.eof()) {
                    rootMarker.done(root);
                    return;
                }
                this.getTypeParser().parseType();
            }
        } else {
            this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)JSParsingContextUtil.IS_TOP_LEVEL_ASYNC);
        }
        this.doParseJS();
        rootMarker.done(root);
    }

    protected void doParseJS() {
        while (!this.builder.eof()) {
            this.getStatementParser().parseStatement();
        }
    }

    public void fillBuilderDataFromContext(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSParsingContextUtil.fillBuilderData(context, this.builder);
    }

    public final void fillBuilderData(boolean isAsyncContext, boolean isGeneratorContext) {
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)isAsyncContext);
        JSParsingContextUtil.setIsGenerator(isGeneratorContext, this.builder);
    }

    public boolean isIdentifierToken(@Nullable IElementType tokenType) {
        return JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public boolean isIdentifierName(@Nullable IElementType firstToken) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken);
    }

    @NotNull
    public final DialectOptionHolder getDialect() {
        return this.language.getOptionHolder();
    }

    public void buildTokenElement(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        marker2.done(type);
    }

    @NotNull
    public final EnumSet<JSModifiersStructure.JSModifiersParseResult> parseModifiers(@NotNull JSModifiersStructure structure, boolean dropIfEmpty, @NotNull Predicate<? super PsiBuilder> isPossibleStateAfterModifiers) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter(isPossibleStateAfterModifiers, (String)"isPossibleStateAfterModifiers");
        int offsetBefore = this.builder.getCurrentOffset();
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker attrList = marker;
        this.getFunctionParser().tryParseES7Decorators();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> parseResults = structure.parseOptimistically(this.builder);
        if (parseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED) && !isPossibleStateAfterModifiers.test((PsiBuilder)this.builder)) {
            attrList.rollbackTo();
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            attrList = marker2;
            this.getFunctionParser().tryParseES7Decorators();
            parseResults = structure.parse(this.builder, isPossibleStateAfterModifiers);
        }
        boolean lexerAdvanced = this.builder.getCurrentOffset() > offsetBefore;
        boolean bl = lexerAdvanced ? parseResults.add(JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED) : parseResults.remove((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
        if (dropIfEmpty && !lexerAdvanced) {
            attrList.drop();
        } else {
            attrList.done(this.getFunctionParser().getAttributeListElementType());
        }
        return parseResults;
    }

    private static final ExpressionParser expressionParser_delegate$lambda$0(JavaScriptParser this$0) {
        return new ExpressionParser<JavaScriptParser>(this$0);
    }

    private static final StatementParser statementParser_delegate$lambda$1(JavaScriptParser this$0) {
        return new StatementParser<JavaScriptParser>(this$0);
    }

    private static final FunctionParser functionParser_delegate$lambda$2(JavaScriptParser this$0) {
        return new FunctionParser<JavaScriptParser>(this$0);
    }

    private static final JSPsiTypeParser typeParser_delegate$lambda$3(JavaScriptParser this$0) {
        return new JSPsiTypeParser<JavaScriptParser>(this$0);
    }

    private static final JSXmlParser xmlParser_delegate$lambda$4(JavaScriptParser this$0) {
        return this$0.language.getOptionHolder().hasFeature(JSLanguageFeature.E4X) ? (JSXmlParser)new JSXmlTokensParser(this$0) : JSXmlParser.Companion.getDUMMY();
    }
}

