/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.TwigLanguage;
import com.jetbrains.twig.TwigLexer;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigCompositeElementType;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.parser.TwigParser;
import org.jetbrains.annotations.NotNull;

public class TwigParserDefinition
implements ParserDefinition {
    public static final IFileElementType TWIG_FILE_TYPE = new IStubFileElementType("TWIG_FILE", (Language)TwigLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new TwigLexer(project);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new TwigParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = TWIG_FILE_TYPE;
        if (iFileElementType == null) {
            TwigParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TwigTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TwigElementTypes.COMMENTS;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TwigTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof TwigCompositeElementType) {
            PsiElement psiElement = ((TwigCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                TwigParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        throw new AssertionError((Object)("Unknown type: " + String.valueOf(type)));
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            TwigParserDefinition.$$$reportNull$$$0(5);
        }
        return new TwigFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            TwigParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    public String toString() {
        return "TwigParserDefinition";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/parser/TwigParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/parser/TwigParserDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

