/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.behat.BehatFrameworkType;
import com.jetbrains.php.behat.version.BehatVersionCache;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import com.jetbrains.php.testFramework.PhpTestFrameworkOldConfigHolder;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Behat", storages={@Storage(value="php.xml")})
public class BehatSettingsManager
implements PersistentStateComponent<State> {
    private static final PhpTestFrameworkType ourFrameworkType = BehatFrameworkType.getInstance();
    private final Project myProject;
    protected State myState = new State();

    public BehatSettingsManager(Project project) {
        this.myProject = project;
        BehatVersionCache.State state = BehatVersionCache.getInstance(project).getState();
        if (state != null && !state.getVersionCache().isEmpty()) {
            state.getVersionCache().clear();
        }
    }

    public static BehatSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            BehatSettingsManager.$$$reportNull$$$0(0);
        }
        return (BehatSettingsManager)project.getService(BehatSettingsManager.class);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getConfigByInterpreter(@Nullable PhpInterpreter interpreter, @Nullable VirtualFile context) {
        return PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getConfigByInterpreter(ourFrameworkType, interpreter, context);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@Nullable PhpInterpreter interpreter, VirtualFile location) {
        return PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getOrCreateByInterpreter(ourFrameworkType, interpreter, location);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            BehatSettingsManager.$$$reportNull$$$0(1);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/behat/BehatSettingsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        private List<PhpTestFrameworkConfiguration> myOldStyleConfigurations = new SmartList();
        private List<PhpTestFrameworkConfiguration> myConfigurations = null;

        @XCollection(propertyElementName="behat_settings", elementTypes={BehatConfiguration.class, BehatBySdkConfiguration.class, BehatOldDefaultConfiguration.class})
        @NotNull
        public List<PhpTestFrameworkConfiguration> getOldStyleConfigurations() {
            List<PhpTestFrameworkConfiguration> list = this.myOldStyleConfigurations;
            if (list == null) {
                State.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setOldStyleConfigurations(@NotNull List<PhpTestFrameworkConfiguration> oldStyleConfigurations) {
            if (oldStyleConfigurations == null) {
                State.$$$reportNull$$$0(1);
            }
            PhpTestFrameworkType frameworkType = BehatFrameworkType.getInstance();
            for (PhpTestFrameworkConfiguration config : oldStyleConfigurations) {
                config.setFrameworkType(frameworkType);
            }
            this.myOldStyleConfigurations = oldStyleConfigurations;
        }

        @Transient
        public List<PhpTestFrameworkConfiguration> getConfigurations() {
            if (this.myConfigurations == null) {
                this.myConfigurations = this.myOldStyleConfigurations.stream().map(s -> s instanceof BehatOldDefaultConfiguration || s instanceof BehatConfiguration || s instanceof BehatBySdkConfiguration ? s.copy() : s).collect(Collectors.toList());
            }
            return this.myConfigurations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/behat/BehatSettingsManager$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldStyleConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldStyleConfigurations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/behat/BehatSettingsManager$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOldStyleConfigurations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class BehatOldConfigHolder
    extends PhpTestFrameworkOldConfigHolder {
        @NotNull
        public PhpTestFrameworkType getFrameworkType() {
            PhpTestFrameworkType phpTestFrameworkType = ourFrameworkType;
            if (phpTestFrameworkType == null) {
                BehatOldConfigHolder.$$$reportNull$$$0(0);
            }
            return phpTestFrameworkType;
        }

        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull Project project) {
            State state;
            if (project == null) {
                BehatOldConfigHolder.$$$reportNull$$$0(1);
            }
            return (state = BehatSettingsManager.getInstance(project).getState()) != null ? state.getConfigurations() : new SmartList();
        }

        public void removeAllConfigurations(@NotNull Project project) {
            State state;
            if (project == null) {
                BehatOldConfigHolder.$$$reportNull$$$0(2);
            }
            if ((state = BehatSettingsManager.getInstance(project).getState()) != null) {
                state.setOldStyleConfigurations(ContainerUtil.emptyList());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/behat/BehatSettingsManager$BehatOldConfigHolder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameworkType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/behat/BehatSettingsManager$BehatOldConfigHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAllConfigurations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    @Tag(value="behat_by_interpreter")
    private static class BehatBySdkConfiguration
    extends PhpTestFrameworkBySdkConfiguration {
        private BehatBySdkConfiguration() {
        }

        @Attribute(value="behat_path")
        @Nullable
        public String getSerializedExecutablePath() {
            return super.getSerializedExecutablePath();
        }
    }

    @Tag(value="BehatSettings")
    private static class BehatConfiguration
    extends PhpTestFrameworkConfigurationIml {
        private BehatConfiguration() {
        }

        @Attribute(value="behat_path")
        @Nullable
        public String getSerializedExecutablePath() {
            return super.getSerializedExecutablePath();
        }
    }

    @Tag(value="PhpTestFrameworkSettings")
    private static class BehatOldDefaultConfiguration
    extends PhpTestFrameworkConfigurationIml {
        private BehatOldDefaultConfiguration() {
        }
    }
}

