/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import org.openoffice.xmerge.merger.Iterator;

public final class ObjectArrayIterator
implements Iterator {
    private Object[] objArray;
    private int currentPosition;

    private ObjectArrayIterator() {
    }

    public ObjectArrayIterator(Object[] objectArray) {
        if (objectArray != null) {
            this.objArray = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.objArray, 0, objectArray.length);
            this.currentPosition = 0;
        } else {
            this.objArray = new Object[0];
        }
    }

    @Override
    public Object next() {
        if (this.currentPosition < this.objArray.length - 1) {
            ++this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    @Override
    public Object previous() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    @Override
    public Object start() {
        this.currentPosition = 0;
        return this.currentElement();
    }

    @Override
    public Object end() {
        if (this.objArray.length > 0) {
            this.currentPosition = this.objArray.length - 1;
        }
        return this.currentElement();
    }

    @Override
    public Object currentElement() {
        if (this.objArray.length > 0) {
            return this.objArray[this.currentPosition];
        }
        return null;
    }

    public void replace(Object object) {
        this.objArray[this.currentPosition] = object;
    }

    public void insert(Object object) {
        Object[] objectArray = new Object[this.objArray.length + 1];
        if (this.currentPosition > 0) {
            System.arraycopy(this.objArray, 0, objectArray, 0, this.currentPosition);
        }
        objectArray[this.currentPosition] = object;
        System.arraycopy(this.objArray, this.currentPosition, objectArray, this.currentPosition + 1, this.objArray.length - this.currentPosition);
        this.objArray = objectArray;
        ++this.currentPosition;
    }

    public void append(Object object) {
        Object[] objectArray = new Object[this.objArray.length + 1];
        int n = this.currentPosition + 1;
        System.arraycopy(this.objArray, 0, objectArray, 0, n);
        objectArray[n] = object;
        if (this.currentPosition < this.objArray.length - 1) {
            System.arraycopy(this.objArray, n, objectArray, n + 1, this.objArray.length - n);
        }
        this.objArray = objectArray;
    }

    public void remove() {
        Object[] objectArray = new Object[this.objArray.length - 1];
        if (this.currentPosition > 0) {
            System.arraycopy(this.objArray, 0, objectArray, 0, this.currentPosition);
        }
        if (this.currentPosition < this.objArray.length - 1) {
            System.arraycopy(this.objArray, this.currentPosition + 1, objectArray, this.currentPosition, this.objArray.length - this.currentPosition - 1);
        }
        this.objArray = objectArray;
        if (this.currentPosition == this.objArray.length) {
            --this.currentPosition;
        }
    }

    @Override
    public int elementCount() {
        return this.objArray.length;
    }

    @Override
    public boolean equivalent(Object object, Object object2) {
        return object.equals(object2);
    }

    @Override
    public void refresh() {
    }
}

