/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaHelper;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Formula
extends CellValue
implements OfficeConstants {
    private byte[] num = new byte[8];
    private byte grbit;
    private byte[] cce = new byte[2];
    private byte[] rgce;
    private FormulaHelper fh = new FormulaHelper();

    public Formula(int n, int n2, String string, int n3, Format format, Workbook workbook) throws Exception {
        this.fh.setWorkbook(workbook);
        this.setRow(n);
        this.setCol(n2);
        this.setIxfe(n3);
        this.setFormula(string);
        String string2 = format.getCategory();
        String string3 = format.getValue();
        if (string2.equalsIgnoreCase("boolean")) {
            this.num[0] = 1;
            this.num[1] = 0;
            this.num[2] = string3.equalsIgnoreCase("true") ? (byte)1 : 0;
            this.num[3] = 0;
            this.num[4] = 0;
            this.num[5] = 0;
            this.num[6] = -1;
            this.num[7] = -1;
        } else if (string2.equalsIgnoreCase("date")) {
            Debug.log((int)4, (String)"Date Formula");
            this.num = EndianConverter.writeDouble((double)this.toExcelSerialDate(format.getValue()));
        } else if (string2.equalsIgnoreCase("time")) {
            Debug.log((int)4, (String)"Time Formula");
            this.num = EndianConverter.writeDouble((double)this.toExcelSerialTime(format.getValue()));
        } else if (string2.equalsIgnoreCase("percentage")) {
            Debug.log((int)4, (String)"Percent Formula");
            double d = Double.parseDouble(format.getValue());
            this.num = EndianConverter.writeDouble((double)d);
        } else if (string2.equalsIgnoreCase("currency")) {
            Debug.log((int)4, (String)"Currency Formula");
        } else if (string2.equalsIgnoreCase("string")) {
            Debug.log((int)4, (String)"String Formula");
            this.num[0] = 0;
            this.num[1] = 0;
            this.num[2] = 0;
            this.num[3] = 0;
            this.num[4] = 0;
            this.num[5] = 0;
            this.num[6] = -1;
            this.num[7] = -1;
        } else {
            Debug.log((int)4, (String)"Float Formula");
            double d = Double.parseDouble(format.getValue());
            this.num = EndianConverter.writeDouble((double)d);
        }
    }

    public void setFormula(String string) throws Exception {
        this.rgce = this.fh.convertCalcToPXL(string);
        this.cce = EndianConverter.writeShort((short)((short)this.rgce.length));
    }

    public Formula(InputStream inputStream, Workbook workbook) throws IOException {
        this.read(inputStream);
        this.fh.setWorkbook(workbook);
    }

    @Override
    public short getBiffType() {
        return 6;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = super.read(inputStream);
        n += inputStream.read(this.num);
        this.grbit = (byte)inputStream.read();
        ++n;
        short s = EndianConverter.readShort((byte[])this.cce);
        this.rgce = new byte[s];
        inputStream.read(this.rgce, 0, s);
        Debug.log((int)4, (String)(" num : " + this.num + "\n\tgrbit : " + this.grbit + " cce : " + EndianConverter.readShort((byte[])this.cce) + " rgce : " + new String(this.rgce, "UTF-16LE") + "\n" + (n += inputStream.read(this.cce)) + " Bytes Read"));
        return n;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        super.write(outputStream);
        outputStream.write(this.num);
        outputStream.write(this.grbit);
        outputStream.write(this.cce);
        outputStream.write(this.rgce);
        Debug.log((int)4, (String)"Writing Formula record");
    }

    public String getValue() throws IOException {
        double d = EndianConverter.readDouble((byte[])this.num);
        Double d2 = new Double(d);
        return d2.toString();
    }

    @Override
    public String getString() throws IOException {
        return this.fh.convertPXLToCalc(this.rgce);
    }

    public long toExcelSerialDate(String string) throws IOException {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        long l = 1461 * (n + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - 12 * ((n2 - 14) / 12)) / 12 - 3 * (n + 4900 + (n2 - 14) / 12) / 100 / 4 + n3 - 2415019 - 32075;
        return l;
    }

    public double toExcelSerialTime(String string) throws IOException {
        int n = Integer.parseInt(string.substring(2, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        int n4 = n * 3600 + n2 * 60 + n3;
        double d = (double)n4 / 86400.0;
        return d;
    }
}

