/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web.data;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.XMLHelper;
import com.sun.star.wizards.common.XMLProvider;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.ui.event.Task;
import com.sun.star.wizards.web.data.CGDesign;
import com.sun.star.wizards.web.data.CGExporter;
import com.sun.star.wizards.web.data.ConfigSetItem;
import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.dom.Node;

public class CGDocument
extends ConfigSetItem
implements XMLProvider {
    public static final int PAGE_TYPE_UNKNOWN = 0;
    public static final int PAGE_TYPE_PAGE = 1;
    public static final int PAGE_TYPE_SLIDE = 2;
    public String cp_Title = PropertyNames.EMPTY_STRING;
    public String cp_Description = PropertyNames.EMPTY_STRING;
    public String cp_URL;
    public String cp_Author = PropertyNames.EMPTY_STRING;
    public String cp_Exporter;
    public String localFilename = PropertyNames.EMPTY_STRING;
    public String urlFilename = PropertyNames.EMPTY_STRING;
    public String title = PropertyNames.EMPTY_STRING;
    public String description = PropertyNames.EMPTY_STRING;
    public String author = PropertyNames.EMPTY_STRING;
    public DateTime createDate;
    public DateTime updateDate;
    public int sizeBytes = -1;
    public int pages = -1;
    public String dirName;
    public String appType;
    public PropertyValue[] mediaDescriptor;
    public boolean isSODocument;
    public boolean isSOOpenable;
    public boolean valid = false;
    public String targetTypeName;

    public CGDocument() {
    }

    public CGDocument(String string, XMultiServiceFactory xMultiServiceFactory, Task task) throws Exception {
        this.cp_URL = this.getSettings().getFileAccess(xMultiServiceFactory).getURL(string);
        if (task == null) {
            task = new Task(PropertyNames.EMPTY_STRING, PropertyNames.EMPTY_STRING, 5);
        }
        this.validate(xMultiServiceFactory, task);
    }

    public void validate(XMultiServiceFactory xMultiServiceFactory, Task task) throws FileNotFoundException, IllegalArgumentException, Exception {
        if (!this.getSettings().getFileAccess(xMultiServiceFactory).exists(this.cp_URL, false)) {
            throw new FileNotFoundException("The given URL does not point to a file");
        }
        if (this.getSettings().getFileAccess(xMultiServiceFactory).isDirectory(this.cp_URL)) {
            throw new IllegalArgumentException("The given URL points to a directory");
        }
        this.mediaDescriptor = OfficeDocument.getFileMediaDecriptor(xMultiServiceFactory, this.cp_URL);
        task.advance(true);
        this.analyzeFileType(this.mediaDescriptor);
        task.advance(true);
        String string = this.getSettings().getFileAccess(xMultiServiceFactory).getPath(this.cp_URL, PropertyNames.EMPTY_STRING);
        this.localFilename = FileAccess.getFilename(string, File.separator);
        XDocumentProperties xDocumentProperties = null;
        task.advance(true);
        if (this.isSOOpenable) {
            XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
            PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("Hidden", Boolean.TRUE), Properties.createProperty("MacroExecutionMode", new Short(0)), Properties.createProperty("UpdateDocMode", new Short(0))};
            XComponent xComponent = ((XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop)).loadComponentFromURL(this.cp_URL, "_default", 0, propertyValueArray);
            xDocumentProperties = ((XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xComponent)).getDocumentProperties();
        }
        task.advance(true);
        if (xDocumentProperties != null) {
            this.title = xDocumentProperties.getTitle();
            this.description = xDocumentProperties.getDescription();
            this.author = xDocumentProperties.getAuthor();
            this.createDate = xDocumentProperties.getCreationDate();
            this.updateDate = xDocumentProperties.getModificationDate();
        } else {
            this.title = this.localFilename;
            this.updateDate = this.getSettings().getFileAccess(xMultiServiceFactory).getLastModified(this.cp_URL);
        }
        task.advance(true);
        this.valid = true;
        if (this.cp_Title.equals(PropertyNames.EMPTY_STRING)) {
            this.cp_Title = this.title;
        }
        if (this.cp_Title.equals(PropertyNames.EMPTY_STRING)) {
            this.cp_Title = this.localFilename;
        }
        if (this.cp_Description.equals(PropertyNames.EMPTY_STRING)) {
            this.cp_Description = this.description;
        }
        if (this.cp_Author.equals(PropertyNames.EMPTY_STRING)) {
            this.cp_Author = this.author;
        }
        if (this.cp_Exporter == null || this.cp_Exporter.equals(PropertyNames.EMPTY_STRING)) {
            this.cp_Exporter = (String)this.getSettings().cp_Exporters.getKey(this.getSettings().getExporters(this.appType)[0]);
        }
    }

    private void analyzeFileType(PropertyValue[] propertyValueArray) {
        if (propertyValueArray == null) {
            // empty if block
        }
        String string = propertyValueArray == null ? PropertyNames.EMPTY_STRING : (String)Properties.getPropertyValue(this.mediaDescriptor, PropertyNames.PROPERTY_NAME);
        this.appType = this.getDocType(string);
        this.isSOOpenable = this.appType.equals("writer") || this.appType.equals("calc") || this.appType.equals("impress") || this.appType.equals("draw") || this.appType.equals("html");
        String[] stringArray = JavaTools.ArrayoutofString(string, "_");
        this.isSODocument = stringArray.length >= 2 && this.isSOOpenable && stringArray[1].startsWith("Star");
    }

    private String getDocType(String string) {
        if (string.equals(PropertyNames.EMPTY_STRING)) {
            return "other";
        }
        if (string.startsWith("writer")) {
            if (string.startsWith("writer_web_HTML")) {
                return "html";
            }
            return "writer";
        }
        if (string.startsWith("calc")) {
            return "calc";
        }
        if (string.startsWith("draw")) {
            return "draw";
        }
        if (string.startsWith("impress")) {
            return "impress";
        }
        if (string.startsWith("pdf")) {
            return "pdf";
        }
        if (string.startsWith("gif") || string.startsWith("jpg")) {
            return "graphics";
        }
        if (string.startsWith("wav")) {
            return "sound";
        }
        return "other";
    }

    public Node createDOM(Node node) {
        CGDesign cGDesign = this.getSettings().cp_DefaultSession.cp_Design;
        CGExporter cGExporter = (CGExporter)this.getSettings().cp_Exporters.getElement(this.cp_Exporter);
        return XMLHelper.addElement(node, "document", new String[]{"title", "description", "author", "format", "filename", "create-date", "update-date", "pages", "size", "icon", "dir", "fn"}, new String[]{cGDesign.cp_DisplayTitle ? this.cp_Title : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayDescription ? this.cp_Description : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayAuthor ? this.cp_Author : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayFileFormat ? this.getTargetTypeName(cGExporter) : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayFilename ? this.localFilename : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayCreateDate ? this.createDate() : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayUpdateDate ? this.updateDate() : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayPages && this.pages > -1 ? PropertyNames.EMPTY_STRING + this.pages() : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplaySize ? this.sizeKB() : PropertyNames.EMPTY_STRING, cGDesign.cp_DisplayFormatIcon ? this.getIcon(cGExporter) : PropertyNames.EMPTY_STRING, this.dirName, this.urlFilename});
    }

    private String updateDate() {
        if (this.updateDate == null) {
            return PropertyNames.EMPTY_STRING;
        }
        return this.getSettings().formatter.formatCreated(this.updateDate);
    }

    private String createDate() {
        if (this.createDate == null) {
            return PropertyNames.EMPTY_STRING;
        }
        return this.getSettings().formatter.formatCreated(this.createDate);
    }

    private String sizeKB() {
        if (this.sizeBytes == -1) {
            return PropertyNames.EMPTY_STRING;
        }
        return this.getSettings().formatter.formatFileSize(this.sizeBytes);
    }

    private String pages() {
        return this.pages == -1 ? PropertyNames.EMPTY_STRING : JavaTools.replaceSubString(this.pagesTemplate(), PropertyNames.EMPTY_STRING + this.pages, "%NUMBER");
    }

    private String pagesTemplate() {
        int n = ((CGExporter)this.getSettings().cp_Exporters.getElement((Object)this.cp_Exporter)).cp_PageType;
        switch (n) {
            case 0: {
                return PropertyNames.EMPTY_STRING;
            }
            case 1: {
                return this.getSettings().resources[0];
            }
            case 2: {
                return this.getSettings().resources[1];
            }
        }
        return PropertyNames.EMPTY_STRING;
    }

    private String getTargetTypeName(CGExporter cGExporter) {
        return cGExporter.targetTypeName.equals(PropertyNames.EMPTY_STRING) ? (String)Properties.getPropertyValue(this.mediaDescriptor, "UIName") : cGExporter.targetTypeName;
    }

    private String getIcon(CGExporter cGExporter) {
        return cGExporter.cp_Icon.equals(PropertyNames.EMPTY_STRING) ? this.getIcon(this.appType) : cGExporter.cp_Icon;
    }

    private String getIcon(String string) {
        return string + ".gif";
    }

    public short[] getExporter() {
        return new short[]{this.getExporterIndex()};
    }

    public void setExporter(short[] sArray) {
        CGExporter cGExporter = this.getSettings().getExporters(this.appType)[sArray[0]];
        this.cp_Exporter = (String)this.getSettings().cp_Exporters.getKey(cGExporter);
    }

    private short getExporterIndex() {
        if (this.cp_Exporter == null) {
            return 0;
        }
        Object object = this.getSettings().cp_Exporters.getElement(this.cp_Exporter);
        CGExporter[] cGExporterArray = this.getSettings().getExporters(this.appType);
        for (short s = 0; s < cGExporterArray.length; s = (short)(s + 1)) {
            if (cGExporterArray[s] != object) continue;
            return s;
        }
        return -1;
    }

    public String toString() {
        return this.localFilename;
    }
}

