/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.help.HelpFileDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;

public class HelpIndexerTool {
    public static void main(String[] stringArray) {
        boolean bl = false;
        HelpIndexerTool.mainImpl(stringArray, bl);
    }

    public static void mainImpl(String[] stringArray, boolean bl) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if ("-extension".equals(stringArray[i])) {
                bl2 = true;
                continue;
            }
            if ("-lang".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string3 = stringArray[i + 1];
                    bl3 = true;
                }
                ++i;
                continue;
            }
            if ("-mod".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string4 = stringArray[i + 1];
                    bl4 = true;
                }
                ++i;
                continue;
            }
            if ("-zipdir".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string = stringArray[i + 1];
                    bl5 = true;
                }
                ++i;
                continue;
            }
            if ("-srcdir".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string2 = stringArray[i + 1];
                    bl6 = true;
                }
                ++i;
                continue;
            }
            if ("-o".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string5 = stringArray[i + 1];
                    bl7 = true;
                }
                ++i;
                continue;
            }
            if (!"-checkcfsandsegname".equals(stringArray[i])) continue;
            if (i + 1 < n) {
                string6 = stringArray[i + 1] + ".cfs";
                bl8 = true;
            }
            if (++i + 1 < n) {
                string7 = "segments" + stringArray[i + 1];
                bl9 = true;
            }
            ++i;
            if (bl8 && bl9) continue;
            System.out.println("Usage: HelpIndexer -checkcfsandsegname _0 _3 (2 arguments needed)");
            System.exit(-1);
        }
        if (!(bl3 && bl4 && bl5 && (bl7 || bl || bl2))) {
            if (bl) {
                return;
            }
            System.out.println("Usage: HelpIndexer -lang ISOLangCode -mod HelpModule -zipdir TempZipDir -o OutputZipFile");
            System.out.println("Usage: HelpIndexer -extension -lang ISOLangCode -mod HelpModule -zipdir PathToLangDir");
            System.exit(-1);
        }
        String string8 = string4 + ".idxl";
        File file = new File(string + File.separator + string8);
        if (!bl6) {
            string2 = string;
        }
        File file2 = new File(string2 + File.separator + "caption");
        File file3 = new File(string2 + File.separator + "content");
        try {
            Object object;
            int n2;
            Date date = new Date();
            Analyzer analyzer = string3.equals("ja") ? new CJKAnalyzer(Version.LUCENE_29) : new StandardAnalyzer(Version.LUCENE_29);
            IndexWriter indexWriter = new IndexWriter((Directory)NIOFSDirectory.open(file), analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
            if (!bl) {
                System.out.println("Lucene: Indexing to directory '" + file + "'...");
            }
            if ((n2 = HelpIndexerTool.indexDocs(indexWriter, string4, bl, file2, file3)) != -1) {
                if (!bl) {
                    System.out.println();
                    System.out.println("Optimizing ...");
                }
                indexWriter.optimize();
            }
            indexWriter.close();
            boolean bl10 = true;
            boolean bl11 = true;
            if (bl8 && bl9 && !bl && n2 != -1) {
                object = string + File.separator + string8 + File.separator + string6;
                String string9 = string + File.separator + string8 + File.separator + string7;
                File file4 = new File((String)object);
                File file5 = new File(string9);
                bl10 = file4.exists();
                bl11 = file5.exists();
                System.out.println("Checking cfs file " + string6 + ": " + (bl10 ? "Found" : "Not found"));
                System.out.println("Checking segment file " + string7 + ": " + (bl11 ? "Found" : "Not found"));
            }
            if (bl || bl2) {
                if (!bl6) {
                    HelpIndexerTool.deleteRecursively(file2);
                    HelpIndexerTool.deleteRecursively(file3);
                }
            } else {
                if (n2 == -1) {
                    HelpIndexerTool.deleteRecursively(file);
                }
                if (bl10 && bl11) {
                    System.out.println("Zipping ...");
                }
                object = new File(string);
                HelpIndexerTool.createZipFile((File)object, string5);
                HelpIndexerTool.deleteRecursively((File)object);
            }
            if (!bl10) {
                System.out.println("cfs file check failed, terminating...");
                System.exit(-1);
            }
            if (!bl11) {
                System.out.println("segment file check failed, terminating...");
                System.exit(-1);
            }
            object = new Date();
            if (!bl) {
                System.out.println(((Date)object).getTime() - date.getTime() + " total milliseconds");
            }
        }
        catch (IOException iOException) {
            if (bl) {
                return;
            }
            System.out.println(" caught a " + iOException.getClass() + "\n with message: " + iOException.getMessage());
            System.exit(-1);
        }
    }

    private static int indexDocs(IndexWriter indexWriter, String string, boolean bl, File file, File file2) throws IOException {
        File file3;
        if (!file.canRead() || !file.isDirectory()) {
            if (!bl) {
                System.out.println("Not found: " + file);
            }
            return -1;
        }
        if (!file2.canRead() || !file2.isDirectory()) {
            if (!bl) {
                System.out.println("Not found: " + file2);
            }
            return -1;
        }
        String[] stringArray = file.list();
        List<String> list = Arrays.asList(stringArray);
        HashSet<String> hashSet = new HashSet<String>(list);
        String[] stringArray2 = file2.list();
        List<String> list2 = Arrays.asList(stringArray2);
        HashSet<String> hashSet2 = new HashSet<String>(list2);
        if (!bl) {
            System.out.println("Indexing, adding files");
        }
        for (String string2 : stringArray) {
            File object = new File(file, string2);
            file3 = null;
            if (hashSet2.contains(string2)) {
                file3 = new File(file2, string2);
            }
            if (!bl) {
                System.out.print(".");
            }
            indexWriter.addDocument(HelpFileDocument.Document(string, object, file3));
        }
        for (String string2 : stringArray2) {
            if (hashSet.contains(string2)) continue;
            file3 = null;
            File file4 = new File(file2, string2);
            if (!bl) {
                System.out.print(".");
            }
            indexWriter.addDocument(HelpFileDocument.Document(string, file3, file4));
        }
        return 0;
    }

    public static void createZipFile(File file, String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            HelpIndexerTool.addToZipRecursively(zipOutputStream, fileArray[i], null);
        }
        zipOutputStream.close();
    }

    public static void addToZipRecursively(ZipOutputStream zipOutputStream, File file, String string) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String string2 = file.getName();
            if (string2.equalsIgnoreCase("caption") || string2.equalsIgnoreCase("content")) {
                return;
            }
            File[] fileArray = file.listFiles();
            String string3 = "";
            if (string != null) {
                string3 = string3 + string + File.separator;
            }
            string3 = string3 + string2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                HelpIndexerTool.addToZipRecursively(zipOutputStream, fileArray[i], string3);
            }
            return;
        }
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        int n2 = fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        String string4 = file.getName();
        String string5 = "";
        if (string != null) {
            string5 = string5 + string + "/";
        }
        string5 = string5 + string4;
        ZipEntry zipEntry = new ZipEntry(string5);
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(n);
        int n3 = string4.toLowerCase().endsWith(".jar") ? 0 : 8;
        zipEntry.setMethod(n3);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        zipEntry.setCrc(cRC32.getValue());
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, n);
        zipOutputStream.closeEntry();
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                boolean bl = HelpIndexerTool.deleteRecursively(file2);
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

