/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.PlainSourceView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;

class GlyphGutter
extends JComponent {
    private PlainSourceView view;
    private final String DUMMY_STRING = "99";

    GlyphGutter(PlainSourceView plainSourceView) {
        this.view = plainSourceView;
        this.update();
    }

    public void update() {
        JTextArea jTextArea = this.view.getTextArea();
        Font font = jTextArea.getFont();
        this.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = jTextArea.getLineCount() + 1;
        String string = Integer.toString(n2);
        if (string.length() < 2) {
            string = "99";
        }
        Dimension dimension = new Dimension();
        dimension.width = fontMetrics.stringWidth(string) + 16;
        dimension.height = n2 * n + 100;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        JTextArea jTextArea = this.view.getTextArea();
        Font font = jTextArea.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = fontMetrics.getMaxAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = jTextArea.getLineCount() + 1;
        int n4 = rectangle.y / n2;
        int n5 = (rectangle.y + rectangle.height) / n2 + 1;
        int n6 = this.getWidth();
        if (n5 > n3) {
            n5 = n3;
        }
        for (int i = n4; i < n5; ++i) {
            String string = Integer.toString(i + 1) + " ";
            int n7 = fontMetrics.stringWidth(string);
            int n8 = i * n2;
            graphics.setColor(Color.blue);
            graphics.drawString(string, 0, n8 + n);
            int n9 = n6 - n;
            if (i != this.view.getCurrentPosition()) continue;
            this.drawArrow(graphics, n, n9, n8);
        }
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3) {
        Polygon polygon = new Polygon();
        int n4 = n2;
        int n5 = n3 += n - 10;
        polygon.addPoint(n4, n5 + 3);
        polygon.addPoint(n4 + 5, n5 + 3);
        n2 = n4 + 5;
        while (n2 <= n4 + 10) {
            polygon.addPoint(n2, n3);
            ++n2;
            ++n3;
        }
        n2 = n4 + 9;
        while (n2 >= n4 + 5) {
            polygon.addPoint(n2, n3);
            --n2;
            ++n3;
        }
        polygon.addPoint(n4 + 5, n5 + 7);
        polygon.addPoint(n4, n5 + 7);
        graphics.setColor(Color.red);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.black);
        graphics.drawPolygon(polygon);
    }
}

