/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Arrays;
import org.springframework.boot.SpringApplicationAotProcessor;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.context.aot.ContextAotProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SpringApplicationAotProcessor
extends ContextAotProcessor {
    private final String[] applicationArgs;

    public SpringApplicationAotProcessor(Class<?> application, AbstractAotProcessor.Settings settings, String[] applicationArgs) {
        super(application, settings);
        this.applicationArgs = applicationArgs;
    }

    protected GenericApplicationContext prepareApplicationContext(Class<?> application) {
        return new AotProcessorHook(application).run(() -> {
            Method mainMethod = application.getMethod("main", String[].class);
            return ReflectionUtils.invokeMethod((Method)mainMethod, null, (Object[])new Object[]{this.applicationArgs});
        });
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Using My org.springframework.boot.SpringApplicationAotProcessor");
        int requiredArgs = 6;
        Assert.isTrue((args.length >= requiredArgs ? 1 : 0) != 0, () -> "Usage: " + SpringApplicationAotProcessor.class.getName() + " <applicationName> <sourceOutput> <resourceOutput> <classOutput> <groupId> <artifactId> <originalArgs...>");
        Class<?> application = Class.forName(args[0]);
        AbstractAotProcessor.Settings settings = AbstractAotProcessor.Settings.builder().sourceOutput(Paths.get(args[1], new String[0])).resourceOutput(Paths.get(args[2], new String[0])).classOutput(Paths.get(args[3], new String[0])).groupId(StringUtils.hasText((String)args[4]) ? args[4] : "unspecified").artifactId(args[5]).build();
        String[] applicationArgs = args.length > requiredArgs ? Arrays.copyOfRange(args, requiredArgs, args.length) : new String[]{};
        new SpringApplicationAotProcessor(application, settings, applicationArgs).process();
        System.exit(0);
    }
}

