/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.webaccess;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Strings;

public class WebAccessException
extends IOException {
    private final String message;
    private String body;
    private int code;

    public WebAccessException(Exception e) {
        super(e);
        this.message = e.getMessage();
    }

    public WebAccessException(String errorMessage) {
        super(errorMessage);
        this.message = errorMessage;
    }

    public WebAccessException(String responseMessage, String body, int code) {
        this.message = responseMessage;
        this.body = body;
        this.code = code;
    }

    @Override
    public String getMessage() {
        return Stream.of(Strings.isNotEmpty((CharSequence)this.message) ? this.message : "", Strings.isNotEmpty((CharSequence)this.body) ? this.body : "", "Code: " + this.code).filter(Strings::isNotEmpty).collect(Collectors.joining(". "));
    }

    public String getBody() {
        return this.body;
    }

    public int getCode() {
        return this.code;
    }
}

