/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.webaccess;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.logging.log4j.util.Strings;
import org.nzbhydra.Jackson;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.nzbhydra.webaccess.WebAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebAccess {
    private static final Logger logger = LoggerFactory.getLogger(WebAccess.class);
    @Autowired
    private HydraOkHttp3ClientHttpRequestFactory requestFactory;
    @Value(value="${nzbhydra.connectionTimeout:10}")
    private int timeout;

    public String callUrl(String url) throws IOException {
        return this.callUrl(url, new HashMap());
    }

    public String callUrl(String url, Map<String, String> headers) throws IOException {
        return this.callUrl(url, headers, this.timeout);
    }

    public String callUrl(String url, Map<String, String> headers, int timeout) throws IOException {
        Request.Builder builder = new Request.Builder().url(url);
        return this.callUrl(url, headers, timeout, builder);
    }

    public String postToUrl(String url, MediaType mediaContent, String content, Map<String, String> headers, int timeout) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).post(RequestBody.create((String)content, (MediaType)mediaContent));
        return this.callUrl(url, headers, timeout, builder);
    }

    public String putToUrl(String url, MediaType mediaContent, String content, Map<String, String> headers, int timeout) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).put(RequestBody.create((String)content, (MediaType)mediaContent));
        return this.callUrl(url, headers, timeout, builder);
    }

    public String deleteToUrl(String url, Map<String, String> headers, int timeout) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).delete();
        return this.callUrl(url, headers, timeout, builder);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String callUrl(String url, Map<String, String> headers, int timeout, Request.Builder builder) throws IOException {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = builder.build();
        OkHttpClient client = this.requestFactory.getOkHttpClient(request.url().uri().getHost(), Integer.valueOf(timeout));
        try (Response response = client.newCall(request).execute();){
            String string;
            block20: {
                ResponseBody body = response.body();
                try {
                    String bodyAsString;
                    try {
                        bodyAsString = body == null ? null : body.string();
                    }
                    catch (IOException e) {
                        bodyAsString = null;
                    }
                    if (!response.isSuccessful()) {
                        if (response.code() == 429) {
                            logger.debug("Error 429 (Too many requests or API call limit exceeded) from {}", (Object)url);
                            String message = response.message();
                            if (Strings.isBlank((String)message)) {
                                message = "Error 429 (Too many requests or API call limit exceeded)";
                            }
                            throw new WebAccessException(message, bodyAsString, response.code());
                        }
                        logger.debug("URL call to {} returned {}: {}\n{}", new Object[]{url, response.code(), response.message(), bodyAsString});
                        throw new WebAccessException(response.message(), bodyAsString, response.code());
                    }
                    string = bodyAsString;
                    if (body == null) break block20;
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                body.close();
            }
            return string;
        }
        catch (ConnectException | SocketTimeoutException e) {
            throw new WebAccessException((Exception)e);
        }
    }

    public <T> T callUrl(String url, Map<String, String> headers, Class<T> clazz) throws IOException {
        String body = this.callUrl(url, headers);
        return (T)Jackson.JSON_MAPPER.readValue(body, clazz);
    }

    public <T> T callUrl(String url, TypeReference<T> valueTypeRef) throws IOException {
        String body = this.callUrl(url);
        return (T)Jackson.JSON_MAPPER.readValue(body, valueTypeRef);
    }

    public void downloadToFile(String url, File file) throws IOException {
        logger.debug("Downloading file from {} to {}", (Object)url, (Object)file.getAbsolutePath());
        Stopwatch stopwatch = Stopwatch.createStarted();
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.requestFactory.getOkHttpClient(request.url().uri().getHost()).newCall(request).execute();
             ResponseBody body = response.body();){
            long contentLength = body.contentLength();
            if (!response.isSuccessful()) {
                String error = String.format("URL call to %s returned %d:%s", url, response.code(), response.message());
                logger.error(error);
                throw new IOException(error);
            }
            try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));){
                sink.writeAll((Source)body.source());
                sink.flush();
            }
            logger.debug(LoggingMarkers.PERFORMANCE, "Took {}ms to download file with {} bytes", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)contentLength);
        }
    }
}

