/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.webaccess;

import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.util.Assert;

class OkHttp3ClientHttpResponse
extends AbstractClientHttpResponse {
    private final Response response;
    private HttpHeaders headers;

    public OkHttp3ClientHttpResponse(Response response) {
        Assert.notNull((Object)response, (String)"Response must not be null");
        this.response = response;
    }

    public int getRawStatusCode() {
        return this.response.code();
    }

    public String getStatusText() {
        return this.response.message();
    }

    public InputStream getBody() throws IOException {
        return this.response.body().byteStream();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            HttpHeaders headers = new HttpHeaders();
            for (String headerName : this.response.headers().names()) {
                for (String headerValue : this.response.headers(headerName)) {
                    headers.add(headerName, headerValue);
                }
            }
            this.headers = headers;
        }
        return this.headers;
    }

    public void close() {
        this.response.body().close();
        this.response.close();
    }
}

