/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.update;

import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.tasks.HydraTask;
import org.nzbhydra.update.UpdateException;
import org.nzbhydra.update.UpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AutomaticUpdater {
    public static String TO_NOTICE_KEY = "automaticUpdateToNotice";
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UpdateManager updateManager;
    @Autowired
    private GenericStorage genericStorage;
    private static final Logger logger = LoggerFactory.getLogger(AutomaticUpdater.class);
    private static final long HOUR = 3600000L;

    @HydraTask(configId="installUpdate", name="Check for and install updates", interval=3600000L)
    @Transactional
    public void checkAndInstall() {
        try {
            if (this.updateManager.isUpdatedExternally()) {
                return;
            }
            UpdateManager.UpdateInfo updateInfo = this.updateManager.getUpdateInfo();
            if (this.configProvider.getBaseConfig().getMain().isUpdateAutomatically() && updateInfo.isUpdateAvailable()) {
                logger.info("Automatic updater found update");
                this.updateManager.installUpdate(updateInfo.getLatestVersion(), true);
            }
        }
        catch (UpdateException e) {
            logger.error("Error while installing update", (Throwable)e);
        }
    }
}

