/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.tasks;

import java.util.List;
import org.nzbhydra.tasks.HydraTaskScheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HydraTasksWeb {
    @Autowired
    private HydraTaskScheduler hydraTaskScheduler;

    @RequestMapping(value={"/internalapi/tasks"}, produces={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public List<HydraTaskScheduler.TaskInformation> getTasks() {
        return this.hydraTaskScheduler.getTasks();
    }

    @RequestMapping(value={"/internalapi/tasks/{taskName}"}, method={RequestMethod.PUT})
    @Secured(value={"ROLE_ADMIN"})
    public List<HydraTaskScheduler.TaskInformation> runTask(@PathVariable String taskName) {
        this.hydraTaskScheduler.runNow(taskName);
        return this.getTasks();
    }
}

