/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.systemcontrol;

import org.jetbrains.annotations.NotNull;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.systemcontrol.SystemControl;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemControlWeb {
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private SystemControl systemControl;
    private static final Logger logger = LoggerFactory.getLogger(SystemControlWeb.class);

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/control/shutdown"}, method={RequestMethod.GET})
    public GenericResponse shutdown(@RequestParam(required=false) Integer returnCode, @RequestParam(required=false) Boolean forceShutdown) throws Exception {
        logger.info("Shutting down due to external request");
        this.systemControl.exitWithReturnCode(returnCode == null ? 0 : returnCode, forceShutdown != null && forceShutdown != false);
        return GenericResponse.ok();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/control/restart"}, method={RequestMethod.GET})
    public GenericResponse restart() throws Exception {
        return this.doRestart();
    }

    @NotNull
    private GenericResponse doRestart() {
        String baseUrl = this.urlCalculator.getRequestBasedUriBuilder().toUriString();
        logger.info("Shutting down due to external request. Restart will be handled by wrapper. Web interface will reload to URL {}", (Object)baseUrl);
        this.systemControl.exitWithReturnCode(22);
        logger.debug("Returning restart OK");
        return GenericResponse.ok((String)baseUrl);
    }

    @CrossOrigin
    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/control/ping"}, method={RequestMethod.GET})
    public GenericResponse ping() throws Exception {
        return GenericResponse.ok();
    }
}

