/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.dtoseventsenums;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SearchResultItem {
    private boolean agePrecise;
    private Map<String, String> attributes = new HashMap();
    private Category category;
    private Integer commentsCount;
    private String commentsLink;
    private String cover;
    private String description;
    private String details;
    private DownloadType downloadType;
    private int duplicateIdentifier;
    private Integer files;
    private Instant firstFound;
    private Integer grabs;
    private String group = null;
    private Long guid;
    private HasNfo hasNfo = HasNfo.MAYBE;
    @NotNull
    private Indexer indexer;
    @NotNull
    private String indexerGuid;
    @NotNull
    private Integer indexerScore;
    @NotNull
    private String link;
    private String originalCategory;
    private boolean passworded;
    private Integer peers;
    private String poster;
    private Instant pubDate;
    private Long searchResultId;
    private Integer seeders;
    private Long size;
    private String source;
    @NotNull
    @NotEmpty
    private String title;
    private Instant usenetDate;

    public Optional<Instant> getUsenetDate() {
        return Optional.ofNullable(this.usenetDate);
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public Optional<String> getPoster() {
        return Optional.ofNullable(this.poster);
    }

    public Optional<String> getCover() {
        return Optional.ofNullable(this.cover);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public long getAgeInDays() {
        return this.getBestDate().until(Instant.now(), ChronoUnit.DAYS);
    }

    public Instant getBestDate() {
        return this.getUsenetDate().orElse(this.getPubDate());
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public static Comparator<SearchResultItem> comparator() {
        return (o1, o2) -> {
            if (o2 == null) {
                return 1;
            }
            if (o2.pubDate == null && o1.pubDate != null) {
                return 1;
            }
            if (o1.pubDate == null && o2.pubDate != null) {
                return -1;
            }
            if (o1.pubDate == null) {
                return 0;
            }
            return o1.getBestDate().compareTo(o2.getBestDate());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResultItem)) {
            return false;
        }
        SearchResultItem item = (SearchResultItem)o;
        return Objects.equal((Object)this.indexer, (Object)item.indexer) && Objects.equal((Object)this.indexerGuid, (Object)item.indexerGuid) && Objects.equal((Object)this.link, (Object)item.link) && Objects.equal((Object)this.title, (Object)item.title);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.indexer, this.indexerGuid, this.link, this.title});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexerName", (Object)this.indexer.getName()).add("guid", (Object)this.guid).add("title", (Object)this.title).add("pubDate", (Object)this.pubDate).add("size", (Object)this.size).toString();
    }

    public boolean isAgePrecise() {
        return this.agePrecise;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Category getCategory() {
        return this.category;
    }

    public Integer getCommentsCount() {
        return this.commentsCount;
    }

    public String getCommentsLink() {
        return this.commentsLink;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public int getDuplicateIdentifier() {
        return this.duplicateIdentifier;
    }

    public Integer getFiles() {
        return this.files;
    }

    public Instant getFirstFound() {
        return this.firstFound;
    }

    public Integer getGrabs() {
        return this.grabs;
    }

    public Long getGuid() {
        return this.guid;
    }

    public HasNfo getHasNfo() {
        return this.hasNfo;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public String getIndexerGuid() {
        return this.indexerGuid;
    }

    public Integer getIndexerScore() {
        return this.indexerScore;
    }

    public String getLink() {
        return this.link;
    }

    public String getOriginalCategory() {
        return this.originalCategory;
    }

    public boolean isPassworded() {
        return this.passworded;
    }

    public Integer getPeers() {
        return this.peers;
    }

    public Instant getPubDate() {
        return this.pubDate;
    }

    public Long getSearchResultId() {
        return this.searchResultId;
    }

    public Integer getSeeders() {
        return this.seeders;
    }

    public Long getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAgePrecise(boolean agePrecise) {
        this.agePrecise = agePrecise;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setCommentsCount(Integer commentsCount) {
        this.commentsCount = commentsCount;
    }

    public void setCommentsLink(String commentsLink) {
        this.commentsLink = commentsLink;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public void setDuplicateIdentifier(int duplicateIdentifier) {
        this.duplicateIdentifier = duplicateIdentifier;
    }

    public void setFiles(Integer files) {
        this.files = files;
    }

    public void setFirstFound(Instant firstFound) {
        this.firstFound = firstFound;
    }

    public void setGrabs(Integer grabs) {
        this.grabs = grabs;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGuid(Long guid) {
        this.guid = guid;
    }

    public void setHasNfo(HasNfo hasNfo) {
        this.hasNfo = hasNfo;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setIndexerGuid(String indexerGuid) {
        this.indexerGuid = indexerGuid;
    }

    public void setIndexerScore(Integer indexerScore) {
        this.indexerScore = indexerScore;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setOriginalCategory(String originalCategory) {
        this.originalCategory = originalCategory;
    }

    public void setPassworded(boolean passworded) {
        this.passworded = passworded;
    }

    public void setPeers(Integer peers) {
        this.peers = peers;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public void setPubDate(Instant pubDate) {
        this.pubDate = pubDate;
    }

    public void setSearchResultId(Long searchResultId) {
        this.searchResultId = searchResultId;
    }

    public void setSeeders(Integer seeders) {
        this.seeders = seeders;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUsenetDate(Instant usenetDate) {
        this.usenetDate = usenetDate;
    }
}

