/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.db;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Parameter;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.IndexerEntity;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
@Table(name="searchresult", indexes={@Index(columnList="indexer_id,indexerguid", unique=true)})
public final class SearchResultEntity {
    @GenericGenerator(name="search-result-sequence", strategy="org.nzbhydra.searching.db.SearchResultSequenceGenerator", parameters={@Parameter(name="sequence_name", value="HIBERNATE_SEQUENCE"), @Parameter(name="increment_size", value="1")})
    @Id
    @GeneratedValue(generator="search-result-sequence", strategy=GenerationType.SEQUENCE)
    private long id;
    @ManyToOne
    @NotNull
    @OnDelete(action=OnDeleteAction.CASCADE)
    private IndexerEntity indexer;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant firstFound;
    @NotNull
    @Column(length=4000)
    private String title;
    @Column(name="indexerguid")
    @NotNull
    private String indexerGuid;
    @Column(length=4000)
    private String link;
    @Column(length=4000)
    private String details;
    @Enumerated(value=EnumType.STRING)
    private DownloadType downloadType;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant pubDate;
    @Column(name="INDEXERSEARCHENTITY")
    private Integer indexerSearchEntityId;

    public SearchResultEntity() {
    }

    public SearchResultEntity(IndexerEntity indexer, Instant firstFound, String title, String indexerGuid, String link, String details, DownloadType downloadType, Instant pubDate) {
        this.indexer = indexer;
        this.firstFound = firstFound;
        this.title = title;
        this.indexerGuid = indexerGuid;
        this.link = link;
        this.details = details;
        this.downloadType = downloadType;
        this.pubDate = pubDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIndexer(IndexerEntity indexer) {
        this.indexer = indexer;
    }

    public void setFirstFound(Instant firstFound) {
        this.firstFound = firstFound;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIndexerGuid(String indexerGuid) {
        this.indexerGuid = indexerGuid;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public void setPubDate(Instant pubDate) {
        this.pubDate = pubDate;
    }

    public Integer getIndexerSearchEntityId() {
        return this.indexerSearchEntityId;
    }

    public void setIndexerSearchEntityId(Integer indexerSearchEntityId) {
        this.indexerSearchEntityId = indexerSearchEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultEntity that = (SearchResultEntity)o;
        if (this.id != 0L || that.id != 0L) {
            return this.id == that.id;
        }
        return Objects.equal((Object)this.indexer, (Object)that.indexer) && Objects.equal((Object)this.indexerGuid, (Object)that.indexerGuid);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexer", (Object)this.indexer.getName()).add("title", (Object)this.title).add("link", (Object)this.link).add("details", (Object)this.details).add("pubDate", (Object)this.pubDate).toString();
    }

    public long getId() {
        return this.id;
    }

    public IndexerEntity getIndexer() {
        return this.indexer;
    }

    public Instant getFirstFound() {
        return this.firstFound;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIndexerGuid() {
        return this.indexerGuid;
    }

    public String getLink() {
        return this.link;
    }

    public String getDetails() {
        return this.details;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public Instant getPubDate() {
        return this.pubDate;
    }
}

