/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.searching.db.IdentifierKeyValuePair;
import org.nzbhydra.springnative.ReflectionMarker;
import org.nzbhydra.web.SessionStorage;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@ReflectionMarker
@Entity
@Table(name="search")
public final class SearchEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @SequenceGenerator(allocationSize=1, name="SEARCH_SEQ")
    private int id;
    @Enumerated(value=EnumType.STRING)
    private SearchSource source;
    @Enumerated(value=EnumType.STRING)
    private SearchType searchType;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant time;
    @OneToMany(cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Set<IdentifierKeyValuePair> identifiers = new HashSet();
    private String categoryName;
    private String query;
    private Integer season;
    private String episode;
    private String title;
    private String author;
    private String username;
    private String ip;
    private String userAgent;

    public SearchEntity() {
        this.time = Instant.now();
        this.username = (String)SessionStorage.username.get();
        this.userAgent = (String)SessionStorage.userAgent.get();
        this.ip = (String)SessionStorage.IP.get();
    }

    @JsonIgnore
    public boolean equalsSearchEntity(SearchEntity that) {
        return Objects.equals(this.categoryName, that.categoryName) && Objects.equals(this.query, that.query) && Objects.equals(this.identifiers, that.identifiers) && Objects.equals(this.season, that.season) && Objects.equals(this.episode, that.episode) && Objects.equals(this.title, that.title) && Objects.equals(this.author, that.author);
    }

    @JsonIgnore
    public int getComparingHash() {
        return Objects.hash(this.getQuery(), this.getCategoryName(), this.getSeason(), this.getEpisode(), this.getTitle(), this.identifiers);
    }

    public int getId() {
        return this.id;
    }

    public SearchSource getSource() {
        return this.source;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public Instant getTime() {
        return this.time;
    }

    public Set<IdentifierKeyValuePair> getIdentifiers() {
        return this.identifiers;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getSeason() {
        return this.season;
    }

    public String getEpisode() {
        return this.episode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSource(SearchSource source) {
        this.source = source;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setIdentifiers(Set<IdentifierKeyValuePair> identifiers) {
        this.identifiers = identifiers;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSeason(Integer season) {
        this.season = season;
    }

    public void setEpisode(String episode) {
        this.episode = episode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchEntity)) {
            return false;
        }
        SearchEntity other = (SearchEntity)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$season = this.getSeason();
        Integer other$season = other.getSeason();
        if (this$season == null ? other$season != null : !((Object)this$season).equals(other$season)) {
            return false;
        }
        SearchSource this$source = this.getSource();
        SearchSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        SearchType this$searchType = this.getSearchType();
        SearchType other$searchType = other.getSearchType();
        if (this$searchType == null ? other$searchType != null : !this$searchType.equals(other$searchType)) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Set this$identifiers = this.getIdentifiers();
        Set other$identifiers = other.getIdentifiers();
        if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        if (this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$episode = this.getEpisode();
        String other$episode = other.getEpisode();
        if (this$episode == null ? other$episode != null : !this$episode.equals(other$episode)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Integer $season = this.getSeason();
        result = result * 59 + ($season == null ? 43 : ((Object)$season).hashCode());
        SearchSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        SearchType $searchType = this.getSearchType();
        result = result * 59 + ($searchType == null ? 43 : $searchType.hashCode());
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Set $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $episode = this.getEpisode();
        result = result * 59 + ($episode == null ? 43 : $episode.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
    }

    public String toString() {
        return "SearchEntity(id=" + this.getId() + ", source=" + String.valueOf(this.getSource()) + ", searchType=" + String.valueOf(this.getSearchType()) + ", time=" + String.valueOf(this.getTime()) + ", identifiers=" + String.valueOf(this.getIdentifiers()) + ", categoryName=" + this.getCategoryName() + ", query=" + this.getQuery() + ", season=" + this.getSeason() + ", episode=" + this.getEpisode() + ", title=" + this.getTitle() + ", author=" + this.getAuthor() + ", username=" + this.getUsername() + ", ip=" + this.getIp() + ", userAgent=" + this.getUserAgent() + ")";
    }
}

