/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.InternalSearchResultProcessor;
import org.nzbhydra.searching.SearchResponse;
import org.nzbhydra.searching.SearchResult;
import org.nzbhydra.searching.SearchState;
import org.nzbhydra.searching.Searcher;
import org.nzbhydra.searching.dtoseventsenums.FallbackSearchInitiatedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchFinishedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSelectionEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchMessageEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchRequestParameters;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.nzbhydra.searching.searchrequests.SearchRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SearchWeb {
    private static final Logger logger = LoggerFactory.getLogger(SearchWeb.class);
    @Autowired
    private Searcher searcher;
    @Autowired
    private CategoryProvider categoryProvider;
    @Autowired
    private SearchRequestFactory searchRequestFactory;
    @Autowired
    private InternalSearchResultProcessor searchResultProcessor;
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    @Autowired
    private CustomQueryAndTitleMappingHandler customQueryAndTitleMappingHandler;
    private final Lock lock = new ReentrantLock();
    private final Map<Long, SearchState> searchStates = ExpiringMap.builder().maxSize(10).expiration(5L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/search"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public SearchResponse search(@RequestBody SearchRequestParameters parameters) {
        SearchRequest searchRequest = this.createSearchRequest(parameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("New search request: {}", (Object)searchRequest);
        SearchResult searchResult = this.searcher.search(searchRequest);
        SearchResponse searchResponse = this.searchResultProcessor.createSearchResponse(searchResult);
        this.lock.lock();
        SearchState searchState = (SearchState)this.searchStates.get(searchRequest.getSearchRequestId());
        searchState.setSearchFinished(true);
        this.sendSearchState(searchState);
        this.lock.unlock();
        logger.info("Web search took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return searchResponse;
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/shortcutSearch/{searchRequestId}"}, method={RequestMethod.POST})
    public void shortcutSearch(@PathVariable Long searchRequestId) {
        logger.info("Requested shortcut of search with ID {}", (Object)searchRequestId);
        this.searcher.shortcutSearch(searchRequestId);
    }

    private void sendSearchState(SearchState searchState) {
        this.messagingTemplate.convertAndSend((Object)"/topic/searchState", (Object)searchState);
    }

    private SearchRequest createSearchRequest(@RequestBody SearchRequestParameters parameters) {
        Category category = this.categoryProvider.getByInternalName(parameters.getCategory());
        SearchType searchType = parameters.getMode() != null && category.getSubtype() == Category.Subtype.ALL ? SearchType.valueOf((String)parameters.getMode().toUpperCase()) : (category.getSearchType() == null ? SearchType.SEARCH : category.getSearchType());
        SearchRequest searchRequest = this.searchRequestFactory.getSearchRequest(searchType, SearchSource.INTERNAL, category, parameters.getSearchRequestId(), parameters.getOffset(), parameters.getLimit());
        searchRequest.setLoadAll(parameters.isLoadAll());
        searchRequest.setIndexers(parameters.getIndexers());
        searchRequest.setQuery(parameters.getQuery());
        searchRequest.setMinage(parameters.getMinage());
        searchRequest.setMaxage(parameters.getMaxage());
        searchRequest.setMinsize(parameters.getMinsize());
        searchRequest.setMaxsize(parameters.getMaxsize());
        if (!Strings.isNullOrEmpty((String)parameters.getTitle())) {
            searchRequest.setTitle(parameters.getTitle());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getImdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.IMDB, parameters.getImdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTmdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TMDB, parameters.getTmdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvrageId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVRAGE, parameters.getTvrageId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVDB, parameters.getTvdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvmazeId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVMAZE, parameters.getTvmazeId());
        }
        if (parameters.getSeason() != null) {
            searchRequest.setSeason(parameters.getSeason());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getEpisode())) {
            searchRequest.setEpisode(parameters.getEpisode());
        }
        if (!searchRequest.getIdentifiers().isEmpty() && searchRequest.getQuery().isPresent()) {
            logger.info("Moving additional search terms '{}' from query to required words", searchRequest.getQuery().get());
            searchRequest.getInternalData().getRequiredWords().addAll(Splitter.on((String)" ").splitToList((CharSequence)searchRequest.getQuery().get()));
            searchRequest.setQuery(null);
        }
        searchRequest = this.searchRequestFactory.extendWithSavedIdentifiers(searchRequest);
        searchRequest = this.customQueryAndTitleMappingHandler.mapSearchRequest(searchRequest);
        SearchState searchState = new SearchState(searchRequest.getSearchRequestId());
        this.searchStates.put(searchRequest.getSearchRequestId(), searchState);
        this.sendSearchState(searchState);
        return searchRequest;
    }

    @EventListener
    public void handleSearchMessageEvent(SearchMessageEvent event) {
        if (this.searchStates.containsKey(event.getSearchRequest().getSearchRequestId())) {
            this.lock.lock();
            SearchState searchState = (SearchState)this.searchStates.get(event.getSearchRequest().getSearchRequestId());
            if (!searchState.getMessages().contains(event.getMessage())) {
                searchState.getMessages().add(event.getMessage());
                searchState.getMessages().sort(Comparator.comparing(x -> x.getMessageSortValue().toLowerCase(Locale.ROOT)));
                this.sendSearchState(searchState);
            }
            this.lock.unlock();
        }
    }

    @EventListener
    public void handleIndexerSelectionEvent(IndexerSelectionEvent event) {
        if (this.searchStates.containsKey(event.getSearchRequest().getSearchRequestId())) {
            this.lock.lock();
            SearchState searchState = (SearchState)this.searchStates.get(event.getSearchRequest().getSearchRequestId());
            searchState.setIndexerSelectionFinished(true);
            searchState.setIndexersSelected(event.getIndexersSelected());
            this.lock.unlock();
            this.sendSearchState(searchState);
        }
    }

    @EventListener
    public void handleFallbackSearchInitatedEvent(FallbackSearchInitiatedEvent event) {
        if (this.searchStates.containsKey(event.getSearchRequest().getSearchRequestId())) {
            this.lock.lock();
            SearchState searchState = (SearchState)this.searchStates.get(event.getSearchRequest().getSearchRequestId());
            searchState.setIndexersSelected(searchState.getIndexersSelected() + 1);
            this.lock.unlock();
            this.sendSearchState(searchState);
        }
    }

    @EventListener
    public void handleIndexerSearchFinishedEvent(IndexerSearchFinishedEvent event) {
        if (this.searchStates.containsKey(event.getSearchRequest().getSearchRequestId())) {
            this.lock.lock();
            SearchState searchState = (SearchState)this.searchStates.get(event.getSearchRequest().getSearchRequestId());
            searchState.setIndexersFinished(searchState.getIndexersFinished() + 1);
            this.lock.unlock();
            this.sendSearchState(searchState);
        }
    }
}

