/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import java.util.List;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.searching.SearchModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties
@EnableConfigurationProperties
public class SearchModuleConfigProvider
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SearchModuleConfigProvider.class);
    private List<IndexerConfig> indexers;
    @Autowired
    private SearchModuleProvider searchModuleProvider;
    @Autowired
    private ConfigProvider configProvider;

    @EventListener
    public void handleNewConfig(ConfigChangedEvent configChangedEvent) {
        this.afterPropertiesSet();
    }

    public void setIndexers(List<IndexerConfig> indexers) {
        this.indexers = indexers;
    }

    public List<IndexerConfig> getIndexers() {
        return this.indexers;
    }

    public void afterPropertiesSet() {
        this.indexers = this.configProvider.getBaseConfig().getIndexers();
        this.searchModuleProvider.loadIndexers(this.indexers);
    }
}

