/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerSearchEntity;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class IndexerSearchCacheEntry {
    private Indexer indexer;
    private List<SearchResultItem> searchResultItems = new ArrayList();
    private IndexerSearchEntity indexerSearchEntity;
    private List<IndexerSearchResult> indexerSearchResults = new ArrayList();
    private int nextResultIndex = 0;

    public IndexerSearchCacheEntry(Indexer indexer) {
        this.indexer = indexer;
    }

    public boolean isLastSuccessful() {
        if (this.indexerSearchResults.isEmpty()) {
            return true;
        }
        return ((IndexerSearchResult)Iterables.getLast((Iterable)this.indexerSearchResults)).isWasSuccessful();
    }

    public List<IndexerSearchResult> getIndexerSearchResults() {
        return Collections.unmodifiableList(this.indexerSearchResults);
    }

    public void addIndexerSearchResult(IndexerSearchResult newIndexerSearchResult) {
        this.indexerSearchResults.add(newIndexerSearchResult);
        this.searchResultItems.clear();
        for (IndexerSearchResult indexerSearchResult : this.indexerSearchResults) {
            this.searchResultItems.addAll(indexerSearchResult.getSearchResultItems());
        }
        this.searchResultItems.sort(Comparator.comparingLong(x -> {
            SearchResultItem searchResultItem = (SearchResultItem)x;
            if (searchResultItem.getBestDate() == null) {
                return 0L;
            }
            return searchResultItem.getBestDate().getEpochSecond();
        }).reversed());
    }

    public List<SearchResultItem> getSearchResultItems() {
        return Collections.unmodifiableList(this.searchResultItems);
    }

    public boolean isMoreResultsInCache() {
        return this.searchResultItems.size() > this.nextResultIndex;
    }

    public SearchResultItem peek() {
        return (SearchResultItem)this.searchResultItems.get(this.nextResultIndex);
    }

    public SearchResultItem pop() {
        return (SearchResultItem)this.searchResultItems.get(this.nextResultIndex++);
    }

    public boolean isMoreResultsAvailable() {
        if (this.indexerSearchResults.isEmpty()) {
            return true;
        }
        return ((IndexerSearchResult)Iterables.getLast((Iterable)this.indexerSearchResults)).isHasMoreResults();
    }

    public boolean isAllPulled() {
        if (this.searchResultItems.isEmpty()) {
            return true;
        }
        return this.searchResultItems.size() < this.nextResultIndex;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public IndexerSearchEntity getIndexerSearchEntity() {
        return this.indexerSearchEntity;
    }

    public int getNextResultIndex() {
        return this.nextResultIndex;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setSearchResultItems(List<SearchResultItem> searchResultItems) {
        this.searchResultItems = searchResultItems;
    }

    public void setIndexerSearchEntity(IndexerSearchEntity indexerSearchEntity) {
        this.indexerSearchEntity = indexerSearchEntity;
    }

    public void setIndexerSearchResults(List<IndexerSearchResult> indexerSearchResults) {
        this.indexerSearchResults = indexerSearchResults;
    }

    public void setNextResultIndex(int nextResultIndex) {
        this.nextResultIndex = nextResultIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexerSearchCacheEntry)) {
            return false;
        }
        IndexerSearchCacheEntry other = (IndexerSearchCacheEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getNextResultIndex() != other.getNextResultIndex()) {
            return false;
        }
        Indexer this$indexer = this.getIndexer();
        Indexer other$indexer = other.getIndexer();
        if (this$indexer == null ? other$indexer != null : !this$indexer.equals(other$indexer)) {
            return false;
        }
        List this$searchResultItems = this.getSearchResultItems();
        List other$searchResultItems = other.getSearchResultItems();
        if (this$searchResultItems == null ? other$searchResultItems != null : !((Object)this$searchResultItems).equals(other$searchResultItems)) {
            return false;
        }
        IndexerSearchEntity this$indexerSearchEntity = this.getIndexerSearchEntity();
        IndexerSearchEntity other$indexerSearchEntity = other.getIndexerSearchEntity();
        if (this$indexerSearchEntity == null ? other$indexerSearchEntity != null : !this$indexerSearchEntity.equals(other$indexerSearchEntity)) {
            return false;
        }
        List this$indexerSearchResults = this.getIndexerSearchResults();
        List other$indexerSearchResults = other.getIndexerSearchResults();
        return !(this$indexerSearchResults == null ? other$indexerSearchResults != null : !((Object)this$indexerSearchResults).equals(other$indexerSearchResults));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexerSearchCacheEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNextResultIndex();
        Indexer $indexer = this.getIndexer();
        result = result * 59 + ($indexer == null ? 43 : $indexer.hashCode());
        List $searchResultItems = this.getSearchResultItems();
        result = result * 59 + ($searchResultItems == null ? 43 : ((Object)$searchResultItems).hashCode());
        IndexerSearchEntity $indexerSearchEntity = this.getIndexerSearchEntity();
        result = result * 59 + ($indexerSearchEntity == null ? 43 : $indexerSearchEntity.hashCode());
        List $indexerSearchResults = this.getIndexerSearchResults();
        result = result * 59 + ($indexerSearchResults == null ? 43 : ((Object)$indexerSearchResults).hashCode());
        return result;
    }

    public String toString() {
        return "IndexerSearchCacheEntry(indexer=" + String.valueOf(this.getIndexer()) + ", searchResultItems=" + String.valueOf(this.getSearchResultItems()) + ", indexerSearchEntity=" + String.valueOf(this.getIndexerSearchEntity()) + ", indexerSearchResults=" + String.valueOf(this.getIndexerSearchResults()) + ", nextResultIndex=" + this.getNextResultIndex() + ")";
    }
}

