/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import java.util.Optional;
import org.nzbhydra.indexers.DetailsResult;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.searching.SearchModuleProvider;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.springframework.stereotype.Component;

@Component
public class DetailsProvider {
    private final SearchResultRepository searchResultRepository;
    private final SearchModuleProvider searchModuleProvider;

    public DetailsProvider(SearchResultRepository searchResultRepository, SearchModuleProvider searchModuleProvider) {
        this.searchResultRepository = searchResultRepository;
        this.searchModuleProvider = searchModuleProvider;
    }

    public DetailsResult getDetails(long resultId) {
        Optional searchResult = this.searchResultRepository.findById((Object)resultId);
        if (searchResult.isEmpty()) {
            return null;
        }
        Indexer indexer = this.searchModuleProvider.getIndexerByName(((SearchResultEntity)searchResult.get()).getIndexer().getName());
        try {
            return indexer.getDetails(((SearchResultEntity)searchResult.get()).getIndexerGuid(), resultId);
        }
        catch (IndexerAccessException e) {
            return DetailsResult.unsuccessful((String)e.getMessage());
        }
    }
}

