/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nzbhydra.Jackson;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutdatedWrapperDetector
implements ProblemDetector {
    private static final Logger logger = LoggerFactory.getLogger(OutdatedWrapperDetector.class);
    public static final String KEY_OUTDATED_WRAPPER_DETECTED = "outdatedWrapperDetected";
    private static final String KEY_OUTDATED_WRAPPER_DETECTED_WARNING_DISPLAYED = "outdatedWrapperDetectedWarningDisplayed";
    @Autowired
    private GenericStorage genericStorage;

    public void executeCheck() {
        if (System.getenv("NZBHYDRA_DISABLE_WRAPPER_CHECK") != null) {
            logger.debug("Wrapper check disabled by environment variable");
            return;
        }
        this.detectOutdatedWrapper();
    }

    public boolean isOutdatedWrapperDetected() {
        return this.genericStorage.get(KEY_OUTDATED_WRAPPER_DETECTED, Boolean.class).orElse(false);
    }

    public boolean isOutdatedWrapperDetectedWarningNotYetShown() {
        return this.genericStorage.get(KEY_OUTDATED_WRAPPER_DETECTED_WARNING_DISPLAYED, Boolean.class).orElse(false) == false;
    }

    public void setOutdatedWrapperDetectedWarningShown() {
        this.genericStorage.save(KEY_OUTDATED_WRAPPER_DETECTED_WARNING_DISPLAYED, (Serializable)Boolean.valueOf(true));
    }

    private void detectOutdatedWrapper() {
        Set expectedHashes;
        List<String> wrapperFilenames = Arrays.asList("NZBHydra2.exe", "NZBHydra2 Console.exe", "nzbhydra2wrapper.py", "nzbhydra2wrapperPy3.py");
        try {
            expectedHashes = (Set)Jackson.JSON_MAPPER.readValue(OutdatedWrapperDetector.class.getResource("/wrapperHashes2.json"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            logger.error("Error while trying to read wrapper hashes", (Throwable)e);
            return;
        }
        boolean anyWrapperFileFound = wrapperFilenames.stream().anyMatch(x -> new File((String)x).exists());
        if (!anyWrapperFileFound) {
            logger.error("Didn't find any of the expected wrapper files ({}) in folder {}", (Object)new File("").getAbsolutePath(), (Object)Joiner.on((String)", ").join(wrapperFilenames));
            return;
        }
        boolean outdatedWrapperFound = false;
        for (String filename : wrapperFilenames) {
            File wrapperFile = new File(filename);
            if (!wrapperFile.exists() || !wrapperFile.isFile()) continue;
            try {
                HashCode hash = Files.asByteSource((File)wrapperFile).hash(Hashing.sha1());
                String actualHash = hash.toString();
                if (expectedHashes.contains(actualHash)) continue;
                logger.warn("Outdated file: {}. Hash: {}", (Object)wrapperFile, (Object)actualHash);
                outdatedWrapperFound = true;
            }
            catch (IOException e) {
                logger.error("Unable to hash file {}", (Object)wrapperFile, (Object)e);
            }
        }
        if (outdatedWrapperFound) {
            this.genericStorage.save(KEY_OUTDATED_WRAPPER_DETECTED_WARNING_DISPLAYED, (Serializable)Boolean.valueOf(false));
            this.genericStorage.save(KEY_OUTDATED_WRAPPER_DETECTED, (Serializable)Boolean.valueOf(true));
            logger.warn("The NZBHydra wrappers (i.e. the executables or python scripts you use to run NZBHydra) seem to be outdated. Please update them:\nShut down NZBHydra, download the latest version and extract *all files* into your main NZBHydra folder (overwriting all). Start NZBHydra again.");
        } else {
            this.genericStorage.save(KEY_OUTDATED_WRAPPER_DETECTED, (Serializable)Boolean.valueOf(false));
        }
    }

    public static void main(String[] args) throws Exception {
        List<File> files = Arrays.asList(new File("releases/windows-release/include/NZBHydra2.exe"), new File("releases/windows-release/include/NZBHydra2 Console.exe"), new File("other/wrapper/nzbhydra2wrapper.py"), new File("other/wrapper/nzbhydra2wrapperPy3.py"));
        HashSet<String> hashes = new HashSet<String>();
        for (File file : files) {
            hashes.add(Files.asByteSource((File)file).hash(Hashing.sha1()).toString());
        }
        System.out.println(Jackson.JSON_MAPPER.writeValueAsString(hashes));
    }
}

