/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.auth.AuthType;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.misc.OpenPortChecker;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenPortProblemDetector
implements ProblemDetector {
    private static final Logger logger = LoggerFactory.getLogger(OpenPortProblemDetector.class);
    private static final int CHECK_EVERY_DAYS = 14;
    static final String KEY = "PORT_OPEN_LAST_CHECK";
    static final String WARNING_KEY = "showOpenToInternetWithoutAuth";
    @Autowired
    private OpenPortChecker openPortChecker;
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private ConfigProvider configProvider;

    public void executeCheck() {
        try {
            AuthType authType = this.configProvider.getBaseConfig().getAuth().getAuthType();
            if (!this.configProvider.getBaseConfig().getMain().isCheckOpenPort()) {
                logger.debug("Not checking for open port because check is disabled");
                return;
            }
            if (authType != AuthType.NONE) {
                logger.debug("Not checking for open port because auth method is {}", (Object)authType);
                return;
            }
            Optional data = this.genericStorage.get(KEY, Instant.class);
            if (data.isPresent() && ((Instant)data.get()).isAfter(Instant.now().minus(14L, ChronoUnit.DAYS))) {
                logger.debug("Not checking for open port because last check was less than {} days ago", (Object)14);
                return;
            }
            String port = String.valueOf(this.configProvider.getBaseConfig().getMain().getPort());
            String publicIp = this.openPortChecker.getPublicIp();
            boolean portOpen = this.openPortChecker.isPortOpen(publicIp, port);
            if (!portOpen) {
                logger.debug("It looks like NZBHydra is not open to the internet under public IP {} and port {}.", (Object)publicIp, (Object)port);
                return;
            }
            logger.debug("Determined that the currently chosen port is open under the public address while no authentication method is selected.");
            logger.warn("Apparently NZBHydra is reachable from the internet via public IP {} and port {}. Please either make it not reachable or enable an authentication method to protect your data.", (Object)publicIp, (Object)port);
            this.genericStorage.setNoSave(KEY, (Serializable)Instant.now());
            this.genericStorage.save(WARNING_KEY, (Serializable)Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("Error determining if NZBHydra is exposed to the internet");
        }
    }
}

