/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import java.io.File;
import java.io.FilenameFilter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeleteOldDatabaseBackupDetector
implements ProblemDetector {
    private static final Logger logger = LoggerFactory.getLogger(DeleteOldDatabaseBackupDetector.class);

    public void executeCheck() {
        File databaseFolder = new File(NzbHydra.getDataFolder(), "database");
        if (!databaseFolder.exists()) {
            return;
        }
        String[] files = databaseFolder.list((FilenameFilter)new WildcardFileFilter("*.old.bak.*"));
        if (files == null) {
            return;
        }
        for (String file : files) {
            String timeMilis = file.substring(file.lastIndexOf(".") + 1);
            Instant creationTime = Instant.ofEpochMilli(Long.parseLong(timeMilis));
            if (!creationTime.isBefore(Instant.now().minus(14L, ChronoUnit.DAYS))) continue;
            logger.info("Found old database migration backup {}. Deleting it", (Object)file);
            new File(databaseFolder, file).delete();
        }
    }
}

