/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.notifications;

import com.google.common.collect.Sets;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.ShutdownEvent;
import org.nzbhydra.config.notification.NotificationEventType;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.notifications.AuthFailureNotificationEvent;
import org.nzbhydra.notifications.DownloadCompletionNotificationEvent;
import org.nzbhydra.notifications.DownloadNotificationEvent;
import org.nzbhydra.notifications.IndexerDisabledNotificationEvent;
import org.nzbhydra.notifications.IndexerReenabledNotificationEvent;
import org.nzbhydra.notifications.IndexerVipExpiryNotificationEvent;
import org.nzbhydra.notifications.NotificationEntity;
import org.nzbhydra.notifications.NotificationEvent;
import org.nzbhydra.notifications.NotificationRepository;
import org.nzbhydra.notifications.UpdateNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@RestController
public class NotificationsWeb {
    private static final Logger logger = LoggerFactory.getLogger(NotificationsWeb.class);
    private static final int INTERVAL = 1000;
    private static final String TOPIC = "/topic/notifications";
    private static final Set<NotificationEvent> NOTIFICATION_EVENTS = Sets.newHashSet((Object[])new NotificationEvent[]{new DownloadNotificationEvent(), new IndexerDisabledNotificationEvent(), new UpdateNotificationEvent(), new DownloadCompletionNotificationEvent(), new IndexerVipExpiryNotificationEvent(), new IndexerReenabledNotificationEvent(), new AuthFailureNotificationEvent()});
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledFuture;
    private final Set<String> connectedSessionIds = new HashSet();

    private void scheduleDownloadStatusSending() {
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            List newNotifications = this.notificationRepository.findAllByDisplayedFalseOrderByTimeDesc();
            if (newNotifications.isEmpty()) {
                return;
            }
            this.messagingTemplate.convertAndSend((Object)TOPIC, (Object)newNotifications);
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @MessageMapping(value={"/markNotificationRead"})
    public void markRead(int id) {
        Optional byId = this.notificationRepository.findById((Object)id);
        if (byId.isEmpty()) {
            logger.error("Unable to mark notification with ID {} as read because no notification with that ID was found", (Object)id);
            return;
        }
        ((NotificationEntity)byId.get()).setDisplayed(true);
        this.notificationRepository.save((Object)((NotificationEntity)byId.get()));
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/notifications/test/{eventType}"}, method={RequestMethod.GET})
    public void testNotification(@PathVariable(value="eventType") String eventType) {
        NotificationEventType notificationEventType = NotificationEventType.valueOf((String)eventType);
        Optional<NotificationEvent> notificationEvent = NOTIFICATION_EVENTS.stream().filter(x -> x != null && x.getEventType() == notificationEventType).findFirst();
        if (notificationEvent.isEmpty()) {
            throw new RuntimeException("Unable to create test notification for event type " + eventType);
        }
        logger.info("Sending test notification for type {}", (Object)eventType);
        this.applicationEventPublisher.publishEvent((Object)notificationEvent.get().getTestInstance());
    }

    @EventListener
    public void onClientSubscribe(SessionSubscribeEvent event) {
        String simpDestination = (String)event.getMessage().getHeaders().get((Object)"simpDestination");
        if (TOPIC.equals(simpDestination)) {
            String simpSessionId = (String)event.getMessage().getHeaders().get((Object)"simpSessionId");
            logger.debug(LoggingMarkers.NOTIFICATIONS, "Registered new connection with session ID {}", (Object)simpSessionId);
            if (this.connectedSessionIds.isEmpty()) {
                logger.debug(LoggingMarkers.NOTIFICATIONS, "Scheduling notification update {}", (Object)simpSessionId);
                this.scheduleDownloadStatusSending();
            }
            this.connectedSessionIds.add(simpSessionId);
        }
    }

    @EventListener
    public void onClientDisconnect(SessionDisconnectEvent event) {
        String simpSessionId = (String)event.getMessage().getHeaders().get((Object)"simpSessionId");
        if (this.connectedSessionIds.contains(simpSessionId)) {
            logger.debug(LoggingMarkers.NOTIFICATIONS, "Registered disconnect with session ID {}", (Object)simpSessionId);
            this.connectedSessionIds.remove(simpSessionId);
            if (this.connectedSessionIds.isEmpty()) {
                if (this.scheduledFuture != null) {
                    logger.debug(LoggingMarkers.NOTIFICATIONS, "Cancelling update schedule because no connections left");
                    this.scheduledFuture.cancel(true);
                    this.scheduledFuture = null;
                } else {
                    logger.debug(LoggingMarkers.NOTIFICATIONS, "No connections found but notifications update was also not scheduled");
                }
            } else {
                logger.debug(LoggingMarkers.NOTIFICATIONS, "Not cancelling schedule because still connections left");
            }
        }
    }

    @EventListener
    public void handleShutdown(ShutdownEvent shutdownEvent) {
        this.onShutdown();
    }

    @PreDestroy
    public void onShutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.scheduler.shutdown();
    }
}

