/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.news;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.mapping.SemanticVersion;
import org.nzbhydra.news.NewsProvider;
import org.nzbhydra.news.ShownNews;
import org.nzbhydra.news.ShownNewsRepository;
import org.nzbhydra.update.UpdateManager;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NewsProvider {
    private static final Logger logger = LoggerFactory.getLogger(NewsProvider.class);
    @Autowired
    private ShownNewsRepository shownNewsRepository;
    @Autowired
    private UpdateManager updateManager;
    @Autowired
    protected WebAccess webAccess;
    @Value(value="${nzbhydra.newsUrl}")
    protected String newsUrl;
    protected Instant lastCheckedForNews = Instant.ofEpochMilli(0L);
    private List<NewsEntry> newsEntries;

    public List<NewsEntry> getNews() throws IOException {
        if (Instant.now().minus(2L, ChronoUnit.HOURS).isAfter(this.lastCheckedForNews)) {
            this.newsEntries = (List)this.webAccess.callUrl(this.newsUrl, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.newsEntries.sort(Comparator.comparing(NewsEntry::getShowForVersion).reversed());
            this.lastCheckedForNews = Instant.now();
        }
        return this.newsEntries;
    }

    public void saveShownForCurrentVersion() throws IOException {
        this.shownNewsRepository.deleteAll((Iterable)this.shownNewsRepository.findAll());
        this.shownNewsRepository.save((Object)new ShownNews(this.updateManager.getCurrentVersionString()));
        logger.debug("Saved that news for version {} and before were shown", (Object)this.updateManager.getCurrentVersionString());
    }

    public List<NewsEntry> getNewsForCurrentVersionAndAfter() throws IOException {
        List shownNews = this.shownNewsRepository.findAll();
        if (shownNews == null || shownNews.isEmpty()) {
            return Collections.emptyList();
        }
        SemanticVersion from = shownNews.size() == 1 ? new SemanticVersion(((ShownNews)shownNews.get(0)).getVersion()) : null;
        SemanticVersion to = new SemanticVersion(this.updateManager.getCurrentVersionString());
        List news = this.getNews();
        return news.stream().filter(x -> this.isShowNewsEntry(from, to, x)).collect(Collectors.toList());
    }

    private boolean isShowNewsEntry(SemanticVersion from, SemanticVersion to, NewsEntry x) {
        return (from == null || !from.isSameOrNewer(x.getShowForVersion())) && !x.getShowForVersion().isUpdateFor(to);
    }
}

